package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link GetTopOutput} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     GetTopOutput createGetTopOutput(int fooXyzzy, int barBaz) {
 *         return new GetTopOutputBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of GetTopOutput, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see GetTopOutput
 *
 */
@Generated("mdsal-binding-generator")
public class GetTopOutputBuilder {

    private Map<TopLevelListKey, TopLevelList> _topLevelList;


    Map<Class<? extends Augmentation<GetTopOutput>>, Augmentation<GetTopOutput>> augmentation = Collections.emptyMap();

    public GetTopOutputBuilder() {
    }
    
    
    
    public GetTopOutputBuilder(TwoLevelList arg) {
        this._topLevelList = arg.getTopLevelList();
    }

    public GetTopOutputBuilder(GetTopOutput base) {
        Map<Class<? extends Augmentation<GetTopOutput>>, Augmentation<GetTopOutput>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._topLevelList = base.getTopLevelList();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>TwoLevelList</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TwoLevelList) {
            this._topLevelList = ((TwoLevelList)arg).getTopLevelList();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[TwoLevelList]");
    }

    public Map<TopLevelListKey, TopLevelList> getTopLevelList() {
        return _topLevelList;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GetTopOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public GetTopOutputBuilder setTopLevelList(final Map<TopLevelListKey, TopLevelList> values) {
        this._topLevelList = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public GetTopOutputBuilder addAugmentation(Augmentation<GetTopOutput> augmentation) {
        Class<? extends Augmentation<GetTopOutput>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public GetTopOutputBuilder removeAugmentation(Class<? extends Augmentation<GetTopOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link GetTopOutput} instance.
     *
     * @return A new {@link GetTopOutput} instance.
     */
    public GetTopOutput build() {
        return new GetTopOutputImpl(this);
    }

    private static final class GetTopOutputImpl
        extends AbstractAugmentable<GetTopOutput>
        implements GetTopOutput {
    
        private final Map<TopLevelListKey, TopLevelList> _topLevelList;
    
        GetTopOutputImpl(GetTopOutputBuilder base) {
            super(base.augmentation);
            this._topLevelList = CodeHelpers.emptyToNull(base.getTopLevelList());
        }
    
        @Override
        public Map<TopLevelListKey, TopLevelList> getTopLevelList() {
            return _topLevelList;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = GetTopOutput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return GetTopOutput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return GetTopOutput.bindingToString(this);
        }
    }
}
