package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.OrderedContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.UnkeyedContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.UnorderedContainer;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link Lists} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Lists createLists(int fooXyzzy, int barBaz) {
 *         return new ListsBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Lists, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Lists
 *
 */
@Generated("mdsal-binding-generator")
public class ListsBuilder {

    private OrderedContainer _orderedContainer;
    private UnkeyedContainer _unkeyedContainer;
    private UnorderedContainer _unorderedContainer;


    Map<Class<? extends Augmentation<Lists>>, Augmentation<Lists>> augmentation = Collections.emptyMap();

    public ListsBuilder() {
    }
    
    

    public ListsBuilder(Lists base) {
        Map<Class<? extends Augmentation<Lists>>, Augmentation<Lists>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._orderedContainer = base.getOrderedContainer();
        this._unkeyedContainer = base.getUnkeyedContainer();
        this._unorderedContainer = base.getUnorderedContainer();
    }


    public OrderedContainer getOrderedContainer() {
        return _orderedContainer;
    }
    
    public UnkeyedContainer getUnkeyedContainer() {
        return _unkeyedContainer;
    }
    
    public UnorderedContainer getUnorderedContainer() {
        return _unorderedContainer;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Lists>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public ListsBuilder setOrderedContainer(final OrderedContainer value) {
        this._orderedContainer = value;
        return this;
    }
    
    public ListsBuilder setUnkeyedContainer(final UnkeyedContainer value) {
        this._unkeyedContainer = value;
        return this;
    }
    
    public ListsBuilder setUnorderedContainer(final UnorderedContainer value) {
        this._unorderedContainer = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ListsBuilder addAugmentation(Augmentation<Lists> augmentation) {
        Class<? extends Augmentation<Lists>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ListsBuilder removeAugmentation(Class<? extends Augmentation<Lists>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Lists} instance.
     *
     * @return A new {@link Lists} instance.
     */
    public Lists build() {
        return new ListsImpl(this);
    }

    private static final class ListsImpl
        extends AbstractAugmentable<Lists>
        implements Lists {
    
        private final OrderedContainer _orderedContainer;
        private final UnkeyedContainer _unkeyedContainer;
        private final UnorderedContainer _unorderedContainer;
    
        ListsImpl(ListsBuilder base) {
            super(base.augmentation);
            this._orderedContainer = base.getOrderedContainer();
            this._unkeyedContainer = base.getUnkeyedContainer();
            this._unorderedContainer = base.getUnorderedContainer();
        }
    
        @Override
        public OrderedContainer getOrderedContainer() {
            return _orderedContainer;
        }
        
        @Override
        public UnkeyedContainer getUnkeyedContainer() {
            return _unkeyedContainer;
        }
        
        @Override
        public UnorderedContainer getUnorderedContainer() {
            return _unorderedContainer;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Lists.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Lists.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Lists.bindingToString(this);
        }
    }
}
