package org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.root.fooroot;
import java.lang.Class;
import java.lang.Integer;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link Barroot} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Barroot createBarroot(int fooXyzzy, int barBaz) {
 *         return new BarrootBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Barroot, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Barroot
 *
 */
@Generated("mdsal-binding-generator")
public class BarrootBuilder {

    private Integer _type;
    private Integer _value;
    private BarrootKey key;


    Map<Class<? extends Augmentation<Barroot>>, Augmentation<Barroot>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public BarrootBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link Barroot}.
     *
     * @param base Barroot from which the builder should be initialized
     */
    public BarrootBuilder(Barroot base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._type = base.getType();
        this._value = base.getValue();
    }


    /**
     * Return current value associated with the property corresponding to {@link Barroot#key()}.
     *
     * @return current value
     */
    public BarrootKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Barroot#getType()}.
     *
     * @return current value
     */
    public Integer getType() {
        return _type;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Barroot#getValue()}.
     *
     * @return current value
     */
    public Integer getValue() {
        return _value;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Barroot>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Barroot#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public BarrootBuilder withKey(final BarrootKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Barroot#getType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public BarrootBuilder setType(final Integer value) {
        this._type = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Barroot#getValue()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public BarrootBuilder setValue(final Integer value) {
        this._value = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public BarrootBuilder addAugmentation(Augmentation<Barroot> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public BarrootBuilder removeAugmentation(Class<? extends Augmentation<Barroot>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Barroot} instance.
     *
     * @return A new {@link Barroot} instance.
     */
    public @NonNull Barroot build() {
        return new BarrootImpl(this);
    }

    private static final class BarrootImpl
        extends AbstractAugmentable<Barroot>
        implements Barroot {
    
        private final Integer _type;
        private final Integer _value;
        private final BarrootKey key;
    
        BarrootImpl(BarrootBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new BarrootKey(base.getType());
            }
            this._type = key.getType();
            this._value = base.getValue();
        }
    
        @Override
        public BarrootKey key() {
            return key;
        }
        
        @Override
        public Integer getType() {
            return _type;
        }
        
        @Override
        public Integer getValue() {
            return _value;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Barroot.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Barroot.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Barroot.bindingToString(this);
        }
    }
}
