package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.complex.from.grouping.ContainerWithUses;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.complex.from.grouping.ListViaUses;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.complex.from.grouping.ListViaUsesKey;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link RpcComplexUsesAugment} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     RpcComplexUsesAugment createRpcComplexUsesAugment(int fooXyzzy, int barBaz) {
 *         return new RpcComplexUsesAugmentBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of RpcComplexUsesAugment, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see RpcComplexUsesAugment
 *
 */
@Generated("mdsal-binding-generator")
public class RpcComplexUsesAugmentBuilder {

    private ContainerWithUses _containerWithUses;
    private Map<ListViaUsesKey, ListViaUses> _listViaUses;



    /**
     * Construct an empty builder.
     */
    public RpcComplexUsesAugmentBuilder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link ComplexFromGrouping}.
     *
     * @param arg ComplexFromGrouping from which the builder should be initialized
     */
    public RpcComplexUsesAugmentBuilder(ComplexFromGrouping arg) {
        this._containerWithUses = arg.getContainerWithUses();
        this._listViaUses = arg.getListViaUses();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link RpcComplexUsesAugment}.
     *
     * @param base RpcComplexUsesAugment from which the builder should be initialized
     */
    public RpcComplexUsesAugmentBuilder(RpcComplexUsesAugment base) {
        this._containerWithUses = base.getContainerWithUses();
        this._listViaUses = base.getListViaUses();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link ComplexFromGrouping}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ComplexFromGrouping castArg) {
            this._containerWithUses = castArg.getContainerWithUses();
            this._listViaUses = castArg.getListViaUses();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ComplexFromGrouping]");
    }

    /**
     * Return current value associated with the property corresponding to {@link RpcComplexUsesAugment#getContainerWithUses()}.
     *
     * @return current value
     */
    public ContainerWithUses getContainerWithUses() {
        return _containerWithUses;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link RpcComplexUsesAugment#getListViaUses()}.
     *
     * @return current value
     */
    public Map<ListViaUsesKey, ListViaUses> getListViaUses() {
        return _listViaUses;
    }

    
    /**
     * Set the property corresponding to {@link RpcComplexUsesAugment#getContainerWithUses()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public RpcComplexUsesAugmentBuilder setContainerWithUses(final ContainerWithUses value) {
        this._containerWithUses = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link RpcComplexUsesAugment#getListViaUses()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public RpcComplexUsesAugmentBuilder setListViaUses(final Map<ListViaUsesKey, ListViaUses> values) {
        this._listViaUses = values;
        return this;
    }
    

    /**
     * A new {@link RpcComplexUsesAugment} instance.
     *
     * @return A new {@link RpcComplexUsesAugment} instance.
     */
    public @NonNull RpcComplexUsesAugment build() {
        return new RpcComplexUsesAugmentImpl(this);
    }

    private static final class RpcComplexUsesAugmentImpl
        implements RpcComplexUsesAugment {
    
        private final ContainerWithUses _containerWithUses;
        private final Map<ListViaUsesKey, ListViaUses> _listViaUses;
    
        RpcComplexUsesAugmentImpl(RpcComplexUsesAugmentBuilder base) {
            this._containerWithUses = base.getContainerWithUses();
            this._listViaUses = CodeHelpers.emptyToNull(base.getListViaUses());
        }
    
        @Override
        public ContainerWithUses getContainerWithUses() {
            return _containerWithUses;
        }
        
        @Override
        public Map<ListViaUsesKey, ListViaUses> getListViaUses() {
            return _listViaUses;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = RpcComplexUsesAugment.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return RpcComplexUsesAugment.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return RpcComplexUsesAugment.bindingToString(this);
        }
    }
}
