package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.list1.List11;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.list1.List11Key;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.list1.List12;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.list1.List12Key;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link List1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     List1 createList1(int fooXyzzy, int barBaz) {
 *         return new List1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of List1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see List1
 *
 */
@Generated("mdsal-binding-generator")
public class List1Builder {

    private String _attrStr;
    private Map<List11Key, List11> _list11;
    private Map<List12Key, List12> _list12;
    private List1Key key;


    Map<Class<? extends Augmentation<List1>>, Augmentation<List1>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public List1Builder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link List1}.
     *
     * @param base List1 from which the builder should be initialized
     */
    public List1Builder(List1 base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._attrStr = base.getAttrStr();
        this._list11 = base.getList11();
        this._list12 = base.getList12();
    }


    /**
     * Return current value associated with the property corresponding to {@link List1#key()}.
     *
     * @return current value
     */
    public List1Key key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link List1#getAttrStr()}.
     *
     * @return current value
     */
    public String getAttrStr() {
        return _attrStr;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link List1#getList11()}.
     *
     * @return current value
     */
    public Map<List11Key, List11> getList11() {
        return _list11;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link List1#getList12()}.
     *
     * @return current value
     */
    public Map<List12Key, List12> getList12() {
        return _list12;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<List1>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link List1#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public List1Builder withKey(final List1Key key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link List1#getAttrStr()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public List1Builder setAttrStr(final String value) {
        this._attrStr = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link List1#getList11()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public List1Builder setList11(final Map<List11Key, List11> values) {
        this._list11 = values;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link List1#getList12()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public List1Builder setList12(final Map<List12Key, List12> values) {
        this._list12 = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public List1Builder addAugmentation(Augmentation<List1> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public List1Builder removeAugmentation(Class<? extends Augmentation<List1>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link List1} instance.
     *
     * @return A new {@link List1} instance.
     */
    public @NonNull List1 build() {
        return new List1Impl(this);
    }

    private static final class List1Impl
        extends AbstractAugmentable<List1>
        implements List1 {
    
        private final String _attrStr;
        private final Map<List11Key, List11> _list11;
        private final Map<List12Key, List12> _list12;
        private final List1Key key;
    
        List1Impl(List1Builder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new List1Key(base.getAttrStr());
            }
            this._attrStr = key.getAttrStr();
            this._list11 = CodeHelpers.emptyToNull(base.getList11());
            this._list12 = CodeHelpers.emptyToNull(base.getList12());
        }
    
        @Override
        public List1Key key() {
            return key;
        }
        
        @Override
        public String getAttrStr() {
            return _attrStr;
        }
        
        @Override
        public Map<List11Key, List11> getList11() {
            return _list11;
        }
        
        @Override
        public Map<List12Key, List12> getList12() {
            return _list12;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = List1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return List1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return List1.bindingToString(this);
        }
    }
}
