package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.cont2;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.CustomEnum;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.EnumGrouping;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Contlist1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Contlist1 createContlist1(int fooXyzzy, int barBaz) {
 *         return new Contlist1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Contlist1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Contlist1
 *
 */
@Generated("mdsal-binding-generator")
public class Contlist1Builder {

    private CustomEnum _attrEnum;
    private String _attrStr;
    private Contlist1Key key;


    Map<Class<? extends Augmentation<Contlist1>>, Augmentation<Contlist1>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public Contlist1Builder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link EnumGrouping}.
     *
     * @param arg EnumGrouping from which the builder should be initialized
     */
    public Contlist1Builder(EnumGrouping arg) {
        this._attrEnum = arg.getAttrEnum();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Contlist1}.
     *
     * @param base Contlist1 from which the builder should be initialized
     */
    public Contlist1Builder(Contlist1 base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._attrStr = base.getAttrStr();
        this._attrEnum = base.getAttrEnum();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link EnumGrouping}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EnumGrouping castArg) {
            this._attrEnum = castArg.getAttrEnum();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[EnumGrouping]");
    }

    /**
     * Return current value associated with the property corresponding to {@link Contlist1#key()}.
     *
     * @return current value
     */
    public Contlist1Key key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Contlist1#getAttrEnum()}.
     *
     * @return current value
     */
    public CustomEnum getAttrEnum() {
        return _attrEnum;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Contlist1#getAttrStr()}.
     *
     * @return current value
     */
    public String getAttrStr() {
        return _attrStr;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Contlist1>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Contlist1#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public Contlist1Builder withKey(final Contlist1Key key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Contlist1#getAttrEnum()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Contlist1Builder setAttrEnum(final CustomEnum value) {
        this._attrEnum = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Contlist1#getAttrStr()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Contlist1Builder setAttrStr(final String value) {
        this._attrStr = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public Contlist1Builder addAugmentation(Augmentation<Contlist1> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public Contlist1Builder removeAugmentation(Class<? extends Augmentation<Contlist1>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Contlist1} instance.
     *
     * @return A new {@link Contlist1} instance.
     */
    public @NonNull Contlist1 build() {
        return new Contlist1Impl(this);
    }

    private static final class Contlist1Impl
        extends AbstractAugmentable<Contlist1>
        implements Contlist1 {
    
        private final CustomEnum _attrEnum;
        private final String _attrStr;
        private final Contlist1Key key;
    
        Contlist1Impl(Contlist1Builder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new Contlist1Key(base.getAttrStr());
            }
            this._attrStr = key.getAttrStr();
            this._attrEnum = base.getAttrEnum();
        }
    
        @Override
        public Contlist1Key key() {
            return key;
        }
        
        @Override
        public CustomEnum getAttrEnum() {
            return _attrEnum;
        }
        
        @Override
        public String getAttrStr() {
            return _attrStr;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Contlist1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Contlist1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Contlist1.bindingToString(this);
        }
    }
}
