package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.notification.rev150205;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Just a testing notification that we can not fly for now.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-test-notification</b>
 * <pre>
 * notification out-of-pixie-dust-notification {
 *   leaf reason {
 *     type string;
 *   }
 *   leaf days-till-new-dust {
 *     type uint16;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link OutOfPixieDustNotificationBuilder}.
 * @see OutOfPixieDustNotificationBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface OutOfPixieDustNotification
    extends
    DataObject,
    Notification<OutOfPixieDustNotification>,
    Augmentable<OutOfPixieDustNotification>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("out-of-pixie-dust-notification");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.notification.rev150205.OutOfPixieDustNotification> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.notification.rev150205.OutOfPixieDustNotification.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.notification.rev150205.@NonNull OutOfPixieDustNotification obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getDaysTillNewDust());
        result = prime * result + Objects.hashCode(obj.getReason());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.notification.rev150205.@NonNull OutOfPixieDustNotification thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.notification.rev150205.OutOfPixieDustNotification other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.notification.rev150205.OutOfPixieDustNotification.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getDaysTillNewDust(), other.getDaysTillNewDust())) {
            return false;
        }
        if (!Objects.equals(thisObj.getReason(), other.getReason())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.notification.rev150205.@NonNull OutOfPixieDustNotification obj) {
        final var helper = MoreObjects.toStringHelper("OutOfPixieDustNotification");
        CodeHelpers.appendValue(helper, "daysTillNewDust", obj.getDaysTillNewDust());
        CodeHelpers.appendValue(helper, "reason", obj.getReason());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return reason, or {@code null} if it is not present.
     *
     * @return {@code String} reason, or {@code null} if it is not present.
     *
     */
    String getReason();
    
    /**
     * Return reason, guaranteed to be non-null.
     *
     * @return {@code String} reason, guaranteed to be non-null.
     * @throws NoSuchElementException if reason is not present
     *
     */
    default @NonNull String requireReason() {
        return CodeHelpers.require(getReason(), "reason");
    }
    
    /**
     * Return daysTillNewDust, or {@code null} if it is not present.
     *
     * @return {@code Uint16} daysTillNewDust, or {@code null} if it is not present.
     *
     */
    Uint16 getDaysTillNewDust();
    
    /**
     * Return daysTillNewDust, guaranteed to be non-null.
     *
     * @return {@code Uint16} daysTillNewDust, guaranteed to be non-null.
     * @throws NoSuchElementException if daysTillNewDust is not present
     *
     */
    default @NonNull Uint16 requireDaysTillNewDust() {
        return CodeHelpers.require(getDaysTillNewDust(), "daystillnewdust");
    }

}

