package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.top.level.list;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link NestedList} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NestedList createNestedList(int fooXyzzy, int barBaz) {
 *         return new NestedListBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NestedList, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NestedList
 *
 */
@Generated("mdsal-binding-generator")
public class NestedListBuilder {

    private String _name;
    private String _type;
    private NestedListKey key;


    Map<Class<? extends Augmentation<NestedList>>, Augmentation<NestedList>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public NestedListBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link NestedList}.
     *
     * @param base NestedList from which the builder should be initialized
     */
    public NestedListBuilder(NestedList base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._type = base.getType();
    }


    /**
     * Return current value associated with the property corresponding to {@link NestedList#key()}.
     *
     * @return current value
     */
    public NestedListKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link NestedList#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link NestedList#getType()}.
     *
     * @return current value
     */
    public String getType() {
        return _type;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NestedList>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link NestedList#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public NestedListBuilder withKey(final NestedListKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link NestedList#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NestedListBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link NestedList#getType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NestedListBuilder setType(final String value) {
        this._type = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NestedListBuilder addAugmentation(Augmentation<NestedList> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NestedListBuilder removeAugmentation(Class<? extends Augmentation<NestedList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link NestedList} instance.
     *
     * @return A new {@link NestedList} instance.
     */
    public @NonNull NestedList build() {
        return new NestedListImpl(this);
    }

    private static final class NestedListImpl
        extends AbstractAugmentable<NestedList>
        implements NestedList {
    
        private final String _name;
        private final String _type;
        private final NestedListKey key;
    
        NestedListImpl(NestedListBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new NestedListKey(base.getName());
            }
            this._name = key.getName();
            this._type = base.getType();
        }
    
        @Override
        public NestedListKey key() {
            return key;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public String getType() {
            return _type;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NestedList.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NestedList.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NestedList.bindingToString(this);
        }
    }
}
