package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-sal-test-store</b>
 * <pre>
 * grouping name-value {
 *   leaf name {
 *     type string;
 *   }
 *   leaf value {
 *     type string;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface NameValue
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("name-value");

    @Override
    Class<? extends NameValue> implementedInterface();
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return value, or {@code null} if it is not present.
     *
     * @return {@code String} value, or {@code null} if it is not present.
     *
     */
    String getValue();
    
    /**
     * Return value, guaranteed to be non-null.
     *
     * @return {@code String} value, guaranteed to be non-null.
     * @throws NoSuchElementException if value is not present
     *
     */
    default @NonNull String requireValue() {
        return CodeHelpers.require(getValue(), "value");
    }

}

