package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.unordered.container;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.NameValue;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link UnorderedList} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     UnorderedList createUnorderedList(int fooXyzzy, int barBaz) {
 *         return new UnorderedListBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of UnorderedList, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see UnorderedList
 *
 */
@Generated("mdsal-binding-generator")
public class UnorderedListBuilder {

    private String _name;
    private String _value;
    private UnorderedListKey key;


    Map<Class<? extends Augmentation<UnorderedList>>, Augmentation<UnorderedList>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public UnorderedListBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link NameValue}.
     *
     * @param arg NameValue from which the builder should be initialized
     */
    public UnorderedListBuilder(NameValue arg) {
        this._name = arg.getName();
        this._value = arg.getValue();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link UnorderedList}.
     *
     * @param base UnorderedList from which the builder should be initialized
     */
    public UnorderedListBuilder(UnorderedList base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._value = base.getValue();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link NameValue}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NameValue castArg) {
            this._name = castArg.getName();
            this._value = castArg.getValue();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[NameValue]");
    }

    /**
     * Return current value associated with the property corresponding to {@link UnorderedList#key()}.
     *
     * @return current value
     */
    public UnorderedListKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link UnorderedList#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link UnorderedList#getValue()}.
     *
     * @return current value
     */
    public String getValue() {
        return _value;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<UnorderedList>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link UnorderedList#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public UnorderedListBuilder withKey(final UnorderedListKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link UnorderedList#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UnorderedListBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link UnorderedList#getValue()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UnorderedListBuilder setValue(final String value) {
        this._value = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public UnorderedListBuilder addAugmentation(Augmentation<UnorderedList> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public UnorderedListBuilder removeAugmentation(Class<? extends Augmentation<UnorderedList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link UnorderedList} instance.
     *
     * @return A new {@link UnorderedList} instance.
     */
    public @NonNull UnorderedList build() {
        return new UnorderedListImpl(this);
    }

    private static final class UnorderedListImpl
        extends AbstractAugmentable<UnorderedList>
        implements UnorderedList {
    
        private final String _name;
        private final String _value;
        private final UnorderedListKey key;
    
        UnorderedListImpl(UnorderedListBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new UnorderedListKey(base.getName());
            }
            this._name = key.getName();
            this._value = base.getValue();
        }
    
        @Override
        public UnorderedListKey key() {
            return key;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public String getValue() {
            return _value;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = UnorderedList.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return UnorderedList.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return UnorderedList.bindingToString(this);
        }
    }
}
