package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link ListInRoot} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ListInRoot createListInRoot(int fooXyzzy, int barBaz) {
 *         return new ListInRootBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ListInRoot, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ListInRoot
 *
 */
@Generated("mdsal-binding-generator")
public class ListInRootBuilder {

    private String _leafA;
    private String _leafB;
    private String _leafC;
    private ListInRootKey key;


    Map<Class<? extends Augmentation<ListInRoot>>, Augmentation<ListInRoot>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ListInRootBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link ListInRoot}.
     *
     * @param base ListInRoot from which the builder should be initialized
     */
    public ListInRootBuilder(ListInRoot base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._leafA = base.getLeafA();
        this._leafB = base.getLeafB();
        this._leafC = base.getLeafC();
    }


    /**
     * Return current value associated with the property corresponding to {@link ListInRoot#key()}.
     *
     * @return current value
     */
    public ListInRootKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ListInRoot#getLeafA()}.
     *
     * @return current value
     */
    public String getLeafA() {
        return _leafA;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ListInRoot#getLeafB()}.
     *
     * @return current value
     */
    public String getLeafB() {
        return _leafB;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ListInRoot#getLeafC()}.
     *
     * @return current value
     */
    public String getLeafC() {
        return _leafC;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ListInRoot>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link ListInRoot#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public ListInRootBuilder withKey(final ListInRootKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ListInRoot#getLeafA()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ListInRootBuilder setLeafA(final String value) {
        this._leafA = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ListInRoot#getLeafB()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ListInRootBuilder setLeafB(final String value) {
        this._leafB = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ListInRoot#getLeafC()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ListInRootBuilder setLeafC(final String value) {
        this._leafC = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ListInRootBuilder addAugmentation(Augmentation<ListInRoot> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ListInRootBuilder removeAugmentation(Class<? extends Augmentation<ListInRoot>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link ListInRoot} instance.
     *
     * @return A new {@link ListInRoot} instance.
     */
    public @NonNull ListInRoot build() {
        return new ListInRootImpl(this);
    }

    private static final class ListInRootImpl
        extends AbstractAugmentable<ListInRoot>
        implements ListInRoot {
    
        private final String _leafA;
        private final String _leafB;
        private final String _leafC;
        private final ListInRootKey key;
    
        ListInRootImpl(ListInRootBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new ListInRootKey(base.getLeafA(), base.getLeafB(), base.getLeafC());
            }
            this._leafA = key.getLeafA();
            this._leafB = key.getLeafB();
            this._leafC = key.getLeafC();
        }
    
        @Override
        public ListInRootKey key() {
            return key;
        }
        
        @Override
        public String getLeafA() {
            return _leafA;
        }
        
        @Override
        public String getLeafB() {
            return _leafB;
        }
        
        @Override
        public String getLeafC() {
            return _leafC;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ListInRoot.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ListInRoot.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ListInRoot.bindingToString(this);
        }
    }
}
