package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

/**
 * This class represents the key of {@link ListInRoot} class.
 *
 * @see ListInRoot
 *
 */
@Generated("mdsal-binding-generator")
public class ListInRootKey
 implements Identifier<ListInRoot> {
    @java.io.Serial
    private static final long serialVersionUID = -7347715263097276047L;
    private final String _leafA;
    private final String _leafB;
    private final String _leafC;


    /**
     * Constructs an instance.
     *
     * @param _leafA the entity leafA
     * @param _leafB the entity leafB
     * @param _leafC the entity leafC
     * @throws NullPointerException if any of the arguments are null
     */
    public ListInRootKey(@NonNull String _leafA, @NonNull String _leafB, @NonNull String _leafC) {
        this._leafA = CodeHelpers.requireKeyProp(_leafA, "leafA");
        this._leafB = CodeHelpers.requireKeyProp(_leafB, "leafB");
        this._leafC = CodeHelpers.requireKeyProp(_leafC, "leafC");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public ListInRootKey(ListInRootKey source) {
        this._leafA = source._leafA;
        this._leafB = source._leafB;
        this._leafC = source._leafC;
    }


    /**
     * Return leafA, guaranteed to be non-null.
     *
     * @return {@code String} leafA, guaranteed to be non-null.
     */
    public @NonNull String getLeafA() {
        return _leafA;
    }
    
    /**
     * Return leafB, guaranteed to be non-null.
     *
     * @return {@code String} leafB, guaranteed to be non-null.
     */
    public @NonNull String getLeafB() {
        return _leafB;
    }
    
    /**
     * Return leafC, guaranteed to be non-null.
     *
     * @return {@code String} leafC, guaranteed to be non-null.
     */
    public @NonNull String getLeafC() {
        return _leafC;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_leafA);
        result = prime * result + Objects.hashCode(_leafB);
        result = prime * result + Objects.hashCode(_leafC);
        return result;
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ListInRootKey)) {
            return false;
        }
        final ListInRootKey other = (ListInRootKey) obj;
        if (!Objects.equals(_leafA, other._leafA)) {
            return false;
        }
        if (!Objects.equals(_leafB, other._leafB)) {
            return false;
        }
        if (!Objects.equals(_leafC, other._leafC)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(ListInRootKey.class);
        CodeHelpers.appendValue(helper, "leafA", _leafA);
        CodeHelpers.appendValue(helper, "leafB", _leafB);
        CodeHelpers.appendValue(helper, "leafC", _leafC);
        return helper.toString();
    }
}

