package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-of-migration-test-model</b>
 * <pre>
 * typedef custom-enum {
 *   type enumeration {
 *     enum type1;
 *     enum type2;
 *     enum type3;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public enum CustomEnum implements EnumTypeObject {
    Type1(0, "type1"),
    
    Type2(1, "type2"),
    
    Type3(2, "type3")
    ;

    private final @NonNull String name;
    private final int value;

    private CustomEnum(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding CustomEnum item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable CustomEnum forName(String name) {
        return switch (name) {
            case "type1" -> Type1;
            case "type2" -> Type2;
            case "type3" -> Type3;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding CustomEnum item, or {@code null} if no such item exists
     */
    public static @Nullable CustomEnum forValue(int intValue) {
        return switch (intValue) {
            case 0 -> Type1;
            case 1 -> Type2;
            case 2 -> Type3;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding CustomEnum item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull CustomEnum ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding CustomEnum item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull CustomEnum ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
