package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;

/**
 * Class that builds {@link NestedListSimpleAugment} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NestedListSimpleAugment createNestedListSimpleAugment(int fooXyzzy, int barBaz) {
 *         return new NestedListSimpleAugmentBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NestedListSimpleAugment, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NestedListSimpleAugment
 *
 */
@Generated("mdsal-binding-generator")
public class NestedListSimpleAugmentBuilder {

    private String _type;



    /**
     * Construct an empty builder.
     */
    public NestedListSimpleAugmentBuilder() {
        // No-op
    }


    /**
     * Construct a builder initialized with state from specified {@link NestedListSimpleAugment}.
     *
     * @param base NestedListSimpleAugment from which the builder should be initialized
     */
    public NestedListSimpleAugmentBuilder(NestedListSimpleAugment base) {
        this._type = base.getType();
    }



    /**
     * Return current value associated with the property corresponding to {@link NestedListSimpleAugment#getType()}.
     *
     * @return current value
     */
    public String getType() {
        return _type;
    }

    
    /**
     * Set the property corresponding to {@link NestedListSimpleAugment#getType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NestedListSimpleAugmentBuilder setType(final String value) {
        this._type = value;
        return this;
    }
    

    /**
     * A new {@link NestedListSimpleAugment} instance.
     *
     * @return A new {@link NestedListSimpleAugment} instance.
     */
    public @NonNull NestedListSimpleAugment build() {
        return new NestedListSimpleAugmentImpl(this);
    }

    private static final class NestedListSimpleAugmentImpl
        implements NestedListSimpleAugment {
    
        private final String _type;
    
        NestedListSimpleAugmentImpl(NestedListSimpleAugmentBuilder base) {
            this._type = base.getType();
        }
    
        @Override
        public String getType() {
            return _type;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NestedListSimpleAugment.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NestedListSimpleAugment.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NestedListSimpleAugment.bindingToString(this);
        }
    }
}
