package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.Cont1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.Cont2;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.List1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.List1Key;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link TllComplexAugment} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TllComplexAugment createTllComplexAugment(int fooXyzzy, int barBaz) {
 *         return new TllComplexAugmentBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TllComplexAugment, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TllComplexAugment
 *
 */
@Generated("mdsal-binding-generator")
public class TllComplexAugmentBuilder {

    private String _attrStr1;
    private String _attrStr2;
    private String _attrStr3;
    private String _attrStr4;
    private Cont1 _cont1;
    private Cont2 _cont2;
    private Map<List1Key, List1> _list1;



    /**
     * Construct an empty builder.
     */
    public TllComplexAugmentBuilder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link AugGrouping}.
     *
     * @param arg AugGrouping from which the builder should be initialized
     */
    public TllComplexAugmentBuilder(AugGrouping arg) {
        this._cont1 = arg.getCont1();
        this._cont2 = arg.getCont2();
        this._attrStr1 = arg.getAttrStr1();
        this._attrStr2 = arg.getAttrStr2();
        this._attrStr3 = arg.getAttrStr3();
        this._attrStr4 = arg.getAttrStr4();
        this._list1 = arg.getList1();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link TllComplexAugment}.
     *
     * @param base TllComplexAugment from which the builder should be initialized
     */
    public TllComplexAugmentBuilder(TllComplexAugment base) {
        this._attrStr1 = base.getAttrStr1();
        this._attrStr2 = base.getAttrStr2();
        this._attrStr3 = base.getAttrStr3();
        this._attrStr4 = base.getAttrStr4();
        this._cont1 = base.getCont1();
        this._cont2 = base.getCont2();
        this._list1 = base.getList1();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link AugGrouping}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AugGrouping castArg) {
            this._cont1 = castArg.getCont1();
            this._cont2 = castArg.getCont2();
            this._attrStr1 = castArg.getAttrStr1();
            this._attrStr2 = castArg.getAttrStr2();
            this._attrStr3 = castArg.getAttrStr3();
            this._attrStr4 = castArg.getAttrStr4();
            this._list1 = castArg.getList1();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[AugGrouping]");
    }


    /**
     * Return current value associated with the property corresponding to {@link TllComplexAugment#getAttrStr1()}.
     *
     * @return current value
     */
    public String getAttrStr1() {
        return _attrStr1;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link TllComplexAugment#getAttrStr2()}.
     *
     * @return current value
     */
    public String getAttrStr2() {
        return _attrStr2;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link TllComplexAugment#getAttrStr3()}.
     *
     * @return current value
     */
    public String getAttrStr3() {
        return _attrStr3;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link TllComplexAugment#getAttrStr4()}.
     *
     * @return current value
     */
    public String getAttrStr4() {
        return _attrStr4;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link TllComplexAugment#getCont1()}.
     *
     * @return current value
     */
    public Cont1 getCont1() {
        return _cont1;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link TllComplexAugment#getCont2()}.
     *
     * @return current value
     */
    public Cont2 getCont2() {
        return _cont2;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link TllComplexAugment#getList1()}.
     *
     * @return current value
     */
    public Map<List1Key, List1> getList1() {
        return _list1;
    }

    
    /**
     * Set the property corresponding to {@link TllComplexAugment#getAttrStr1()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TllComplexAugmentBuilder setAttrStr1(final String value) {
        this._attrStr1 = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link TllComplexAugment#getAttrStr2()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TllComplexAugmentBuilder setAttrStr2(final String value) {
        this._attrStr2 = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link TllComplexAugment#getAttrStr3()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TllComplexAugmentBuilder setAttrStr3(final String value) {
        this._attrStr3 = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link TllComplexAugment#getAttrStr4()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TllComplexAugmentBuilder setAttrStr4(final String value) {
        this._attrStr4 = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link TllComplexAugment#getCont1()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TllComplexAugmentBuilder setCont1(final Cont1 value) {
        this._cont1 = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link TllComplexAugment#getCont2()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TllComplexAugmentBuilder setCont2(final Cont2 value) {
        this._cont2 = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link TllComplexAugment#getList1()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public TllComplexAugmentBuilder setList1(final Map<List1Key, List1> values) {
        this._list1 = values;
        return this;
    }
    

    /**
     * A new {@link TllComplexAugment} instance.
     *
     * @return A new {@link TllComplexAugment} instance.
     */
    public @NonNull TllComplexAugment build() {
        return new TllComplexAugmentImpl(this);
    }

    private static final class TllComplexAugmentImpl
        implements TllComplexAugment {
    
        private final String _attrStr1;
        private final String _attrStr2;
        private final String _attrStr3;
        private final String _attrStr4;
        private final Cont1 _cont1;
        private final Cont2 _cont2;
        private final Map<List1Key, List1> _list1;
    
        TllComplexAugmentImpl(TllComplexAugmentBuilder base) {
            this._attrStr1 = base.getAttrStr1();
            this._attrStr2 = base.getAttrStr2();
            this._attrStr3 = base.getAttrStr3();
            this._attrStr4 = base.getAttrStr4();
            this._cont1 = base.getCont1();
            this._cont2 = base.getCont2();
            this._list1 = CodeHelpers.emptyToNull(base.getList1());
        }
    
        @Override
        public String getAttrStr1() {
            return _attrStr1;
        }
        
        @Override
        public String getAttrStr2() {
            return _attrStr2;
        }
        
        @Override
        public String getAttrStr3() {
            return _attrStr3;
        }
        
        @Override
        public String getAttrStr4() {
            return _attrStr4;
        }
        
        @Override
        public Cont1 getCont1() {
            return _cont1;
        }
        
        @Override
        public Cont2 getCont2() {
            return _cont2;
        }
        
        @Override
        public Map<List1Key, List1> getList1() {
            return _list1;
        }
    
        
        
        
        
        @Override
        public Cont1 nonnullCont1() {
            return Objects.requireNonNullElse(getCont1(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.Cont1Builder.empty());
        }
        
        @Override
        public Cont2 nonnullCont2() {
            return Objects.requireNonNullElse(getCont2(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.Cont2Builder.empty());
        }
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = TllComplexAugment.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return TllComplexAugment.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return TllComplexAugment.bindingToString(this);
        }
    }
}
