package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;

/**
 * Class that builds {@link RpcLeafOnlyAugment} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     RpcLeafOnlyAugment createRpcLeafOnlyAugment(int fooXyzzy, int barBaz) {
 *         return new RpcLeafOnlyAugmentBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of RpcLeafOnlyAugment, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see RpcLeafOnlyAugment
 *
 */
@Generated("mdsal-binding-generator")
public class RpcLeafOnlyAugmentBuilder {

    private String _simpleValue;



    /**
     * Construct an empty builder.
     */
    public RpcLeafOnlyAugmentBuilder() {
        // No-op
    }


    /**
     * Construct a builder initialized with state from specified {@link RpcLeafOnlyAugment}.
     *
     * @param base RpcLeafOnlyAugment from which the builder should be initialized
     */
    public RpcLeafOnlyAugmentBuilder(RpcLeafOnlyAugment base) {
        this._simpleValue = base.getSimpleValue();
    }



    /**
     * Return current value associated with the property corresponding to {@link RpcLeafOnlyAugment#getSimpleValue()}.
     *
     * @return current value
     */
    public String getSimpleValue() {
        return _simpleValue;
    }

    
    /**
     * Set the property corresponding to {@link RpcLeafOnlyAugment#getSimpleValue()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public RpcLeafOnlyAugmentBuilder setSimpleValue(final String value) {
        this._simpleValue = value;
        return this;
    }
    

    /**
     * A new {@link RpcLeafOnlyAugment} instance.
     *
     * @return A new {@link RpcLeafOnlyAugment} instance.
     */
    public @NonNull RpcLeafOnlyAugment build() {
        return new RpcLeafOnlyAugmentImpl(this);
    }

    private static final class RpcLeafOnlyAugmentImpl
        implements RpcLeafOnlyAugment {
    
        private final String _simpleValue;
    
        RpcLeafOnlyAugmentImpl(RpcLeafOnlyAugmentBuilder base) {
            this._simpleValue = base.getSimpleValue();
        }
    
        @Override
        public String getSimpleValue() {
            return _simpleValue;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = RpcLeafOnlyAugment.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return RpcLeafOnlyAugment.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return RpcLeafOnlyAugment.bindingToString(this);
        }
    }
}
