/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.samples.loadbalancer;

import org.opendaylight.controller.sal.packet.IPv4;
import org.opendaylight.controller.sal.packet.Packet;
import org.opendaylight.controller.sal.packet.TCP;
import org.opendaylight.controller.sal.packet.UDP;
import org.opendaylight.controller.sal.utils.IPProtocols;
import org.opendaylight.controller.sal.utils.NetUtils;
import org.opendaylight.controller.samples.loadbalancer.entities.Client;
import org.opendaylight.controller.samples.loadbalancer.entities.VIP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LBUtil {
    private static final Logger lbuLogger = LoggerFactory.getLogger(LBUtil.class);

    public Client getClientFromPacket(IPv4 inPkt) {
        lbuLogger.trace("Find client information from packet : {}", (Object)inPkt.toString());
        String ip = NetUtils.getInetAddress((int)inPkt.getSourceAddress()).getHostAddress();
        String protocol = IPProtocols.getProtocolName((byte)inPkt.getProtocol());
        lbuLogger.trace("client ip {} and protocl {}", (Object)ip, (Object)protocol);
        Packet tpFrame = inPkt.getPayload();
        lbuLogger.trace("Get protocol layer {}", (Object)tpFrame.toString());
        short port = 0;
        if (protocol.equals(IPProtocols.TCP.toString())) {
            TCP tcpFrame = (TCP)tpFrame;
            port = tcpFrame.getSourcePort();
        } else {
            UDP udpFrame = (UDP)tpFrame;
            port = udpFrame.getSourcePort();
        }
        lbuLogger.trace("Found port {}", (Object)port);
        Client source = new Client(ip, protocol, port);
        lbuLogger.trace("Client information : {}", (Object)source.toString());
        return source;
    }

    public VIP getVIPFromPacket(IPv4 inPkt) {
        lbuLogger.trace("Find VIP information from packet : {}", (Object)inPkt.toString());
        String ip = NetUtils.getInetAddress((int)inPkt.getDestinationAddress()).getHostAddress();
        String protocol = IPProtocols.getProtocolName((byte)inPkt.getProtocol());
        Packet tpFrame = inPkt.getPayload();
        short port = 0;
        if (protocol.equals(IPProtocols.TCP.toString())) {
            TCP tcpFrame = (TCP)tpFrame;
            port = tcpFrame.getDestinationPort();
        } else {
            UDP udpFrame = (UDP)tpFrame;
            port = udpFrame.getDestinationPort();
        }
        VIP dest = new VIP(null, ip, protocol, port, null);
        lbuLogger.trace("VIP information : {}", (Object)dest.toString());
        return dest;
    }
}

