/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.samples.loadbalancer.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Set;
import org.apache.felix.dm.Component;
import org.opendaylight.controller.forwardingrulesmanager.FlowEntry;
import org.opendaylight.controller.forwardingrulesmanager.IForwardingRulesManager;
import org.opendaylight.controller.hosttracker.HostIdFactory;
import org.opendaylight.controller.hosttracker.IHostId;
import org.opendaylight.controller.hosttracker.IfIptoHost;
import org.opendaylight.controller.hosttracker.hostAware.HostNodeConnector;
import org.opendaylight.controller.sal.action.Output;
import org.opendaylight.controller.sal.action.SetDlDst;
import org.opendaylight.controller.sal.action.SetDlSrc;
import org.opendaylight.controller.sal.action.SetNwDst;
import org.opendaylight.controller.sal.action.SetNwSrc;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Path;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.match.Match;
import org.opendaylight.controller.sal.match.MatchType;
import org.opendaylight.controller.sal.packet.Ethernet;
import org.opendaylight.controller.sal.packet.IDataPacketService;
import org.opendaylight.controller.sal.packet.IListenDataPacket;
import org.opendaylight.controller.sal.packet.IPv4;
import org.opendaylight.controller.sal.packet.Packet;
import org.opendaylight.controller.sal.packet.PacketResult;
import org.opendaylight.controller.sal.packet.RawPacket;
import org.opendaylight.controller.sal.routing.IRouting;
import org.opendaylight.controller.sal.utils.EtherTypes;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.IPProtocols;
import org.opendaylight.controller.samples.loadbalancer.ConfigManager;
import org.opendaylight.controller.samples.loadbalancer.IConfigManager;
import org.opendaylight.controller.samples.loadbalancer.LBUtil;
import org.opendaylight.controller.samples.loadbalancer.entities.Client;
import org.opendaylight.controller.samples.loadbalancer.entities.Pool;
import org.opendaylight.controller.samples.loadbalancer.entities.PoolMember;
import org.opendaylight.controller.samples.loadbalancer.entities.VIP;
import org.opendaylight.controller.samples.loadbalancer.policies.RandomLBPolicy;
import org.opendaylight.controller.samples.loadbalancer.policies.RoundRobinLBPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerService
implements IListenDataPacket,
IConfigManager {
    private static Logger lbsLogger = LoggerFactory.getLogger(LoadBalancerService.class);
    private static ConfigManager configManager = new ConfigManager();
    private static RoundRobinLBPolicy rrLBMethod = new RoundRobinLBPolicy(configManager);
    private static RandomLBPolicy ranLBMethod = new RandomLBPolicy(configManager);
    private IDataPacketService dataPacketService = null;
    private IfIptoHost hostTracker;
    private IForwardingRulesManager ruleManager;
    private IRouting routing;
    private static short LB_IPSWITCH_PRIORITY = (short)2;
    private String containerName = null;

    public String getContainerName() {
        if (this.containerName == null) {
            return GlobalConstants.DEFAULT.toString();
        }
        return this.containerName;
    }

    void setDataPacketService(IDataPacketService s) {
        this.dataPacketService = s;
    }

    void unsetDataPacketService(IDataPacketService s) {
        if (this.dataPacketService == s) {
            this.dataPacketService = null;
        }
    }

    public void setRouting(IRouting routing) {
        this.routing = routing;
    }

    public void unsetRouting(IRouting routing) {
        if (this.routing == routing) {
            this.routing = null;
        }
    }

    public void setHostTracker(IfIptoHost hostTracker) {
        lbsLogger.debug("Setting HostTracker");
        this.hostTracker = hostTracker;
    }

    public void unsetHostTracker(IfIptoHost hostTracker) {
        if (this.hostTracker == hostTracker) {
            this.hostTracker = null;
        }
    }

    public void setForwardingRulesManager(IForwardingRulesManager forwardingRulesManager) {
        lbsLogger.debug("Setting ForwardingRulesManager");
        this.ruleManager = forwardingRulesManager;
    }

    public void unsetForwardingRulesManager(IForwardingRulesManager forwardingRulesManager) {
        if (this.ruleManager == forwardingRulesManager) {
            this.ruleManager = null;
        }
    }

    public PacketResult receiveDataPacket(RawPacket inPkt) {
        if (inPkt == null) {
            return PacketResult.IGNORED;
        }
        Packet formattedPak = this.dataPacketService.decodeDataPacket(inPkt);
        if (formattedPak instanceof Ethernet) {
            byte[] vipMacAddr = ((Ethernet)formattedPak).getDestinationMACAddress();
            Packet ipPkt = formattedPak.getPayload();
            if (ipPkt instanceof IPv4) {
                lbsLogger.debug("Packet recieved from switch : {}", (Object)inPkt.getIncomingNodeConnector().getNode().toString());
                IPv4 ipv4Pkt = (IPv4)ipPkt;
                if (IPProtocols.getProtocolName((byte)ipv4Pkt.getProtocol()).equals(IPProtocols.TCP.toString()) || IPProtocols.getProtocolName((byte)ipv4Pkt.getProtocol()).equals(IPProtocols.UDP.toString())) {
                    lbsLogger.debug("Packet protocol : {}", (Object)IPProtocols.getProtocolName((byte)ipv4Pkt.getProtocol()));
                    Client client = new LBUtil().getClientFromPacket(ipv4Pkt);
                    VIP vip = new LBUtil().getVIPFromPacket(ipv4Pkt);
                    if (configManager.vipExists(vip)) {
                        VIP vipWithPoolName = configManager.getVIPWithPoolName(vip);
                        String poolMemberIp = null;
                        if (vipWithPoolName.getPoolName() == null) {
                            lbsLogger.error("No pool attached. Please attach pool with the VIP -- {}", (Object)vip);
                            return PacketResult.IGNORED;
                        }
                        if (configManager.getPool(vipWithPoolName.getPoolName()).getLbMethod().equalsIgnoreCase("roundrobin")) {
                            poolMemberIp = rrLBMethod.getPoolMemberForClient(client, vipWithPoolName);
                        }
                        if (configManager.getPool(vipWithPoolName.getPoolName()).getLbMethod().equalsIgnoreCase("random")) {
                            poolMemberIp = ranLBMethod.getPoolMemberForClient(client, vipWithPoolName);
                        }
                        try {
                            Node clientNode = inPkt.getIncomingNodeConnector().getNode();
                            IHostId id = HostIdFactory.create((InetAddress)InetAddress.getByName(poolMemberIp), null);
                            HostNodeConnector hnConnector = this.hostTracker.hostFind(id);
                            Node destNode = hnConnector.getnodeconnectorNode();
                            lbsLogger.debug("Client is connected to switch : {}", (Object)clientNode.toString());
                            lbsLogger.debug("Destination pool machine is connected to switch : {}", (Object)destNode.toString());
                            NodeConnector forwardPort = null;
                            if (clientNode.getNodeIDString().equals(destNode.getNodeIDString())) {
                                forwardPort = hnConnector.getnodeConnector();
                                lbsLogger.trace("Both source (client) and destination pool machine is connected to same switch nodes. Respective ports are - {},{}", (Object)forwardPort, (Object)inPkt.getIncomingNodeConnector());
                            } else {
                                Path route = this.routing.getRoute(clientNode, destNode);
                                lbsLogger.trace("Path between source (client) and destination switch nodes : {}", (Object)route.toString());
                                forwardPort = ((Edge)route.getEdges().get(0)).getTailNodeConnector();
                            }
                            if (this.installLoadBalancerFlow(client, vip, clientNode, poolMemberIp, hnConnector.getDataLayerAddressBytes(), forwardPort, 0)) {
                                lbsLogger.trace("Traffic from client : {} will be routed to pool machine : {}", (Object)client, (Object)poolMemberIp);
                            } else {
                                lbsLogger.error("Not able to route traffic from client : {}", (Object)client);
                            }
                            if (this.installLoadBalancerFlow(client, vip, clientNode, poolMemberIp, vipMacAddr, inPkt.getIncomingNodeConnector(), 1)) {
                                lbsLogger.trace("Flow rule installed to change the source ip/mac from pool machine ip {} to VIP {} for traffic coming pool machine", (Object)poolMemberIp, (Object)vip);
                            } else {
                                lbsLogger.error("Not able to route traffic from client : {}", (Object)client);
                            }
                        }
                        catch (UnknownHostException e) {
                            lbsLogger.error("Pool member not found  in the network : {}", (Object)e.getMessage());
                            lbsLogger.error("", (Throwable)e);
                        }
                    }
                }
            }
        }
        return PacketResult.IGNORED;
    }

    private boolean installLoadBalancerFlow(Client source, VIP dest, Node sourceSwitch, String destMachineIp, byte[] destMachineMac, NodeConnector outport, int flowDirection) throws UnknownHostException {
        Match match = new Match();
        ArrayList<Object> actions = new ArrayList<Object>();
        if (flowDirection == 0) {
            match.setField(MatchType.DL_TYPE, (Object)EtherTypes.IPv4.shortValue());
            match.setField(MatchType.NW_SRC, (Object)InetAddress.getByName(source.getIp()));
            match.setField(MatchType.NW_DST, (Object)InetAddress.getByName(dest.getIp()));
            match.setField(MatchType.NW_PROTO, (Object)IPProtocols.getProtocolNumberByte((String)dest.getProtocol()));
            match.setField(MatchType.TP_SRC, (Object)source.getPort());
            match.setField(MatchType.TP_DST, (Object)dest.getPort());
            actions.add(new SetNwDst(InetAddress.getByName(destMachineIp)));
            actions.add(new SetDlDst(destMachineMac));
        }
        if (flowDirection == 1) {
            match.setField(MatchType.DL_TYPE, (Object)EtherTypes.IPv4.shortValue());
            match.setField(MatchType.NW_SRC, (Object)InetAddress.getByName(destMachineIp));
            match.setField(MatchType.NW_DST, (Object)InetAddress.getByName(source.getIp()));
            match.setField(MatchType.NW_PROTO, (Object)IPProtocols.getProtocolNumberByte((String)source.getProtocol()));
            match.setField(MatchType.TP_SRC, (Object)dest.getPort());
            match.setField(MatchType.TP_DST, (Object)source.getPort());
            actions.add(new SetNwSrc(InetAddress.getByName(dest.getIp())));
            actions.add(new SetDlSrc(destMachineMac));
        }
        actions.add(new Output(outport));
        Flow flow = new Flow(match, actions);
        flow.setIdleTimeout((short)5);
        flow.setHardTimeout((short)0);
        flow.setPriority(LB_IPSWITCH_PRIORITY);
        String policyName = source.getIp() + ":" + source.getProtocol() + ":" + source.getPort();
        String flowName = null;
        if (flowDirection == 0) {
            flowName = "[" + policyName + ":" + source.getIp() + ":" + dest.getIp() + "]";
        }
        if (flowDirection == 1) {
            flowName = "[" + policyName + ":" + dest.getIp() + ":" + source.getIp() + "]";
        }
        FlowEntry fEntry = new FlowEntry(policyName, flowName, flow, sourceSwitch);
        lbsLogger.trace("Install flow entry {} on node {}", (Object)fEntry.toString(), (Object)sourceSwitch.toString());
        if (!this.ruleManager.checkFlowEntryConflict(fEntry)) {
            if (this.ruleManager.installFlowEntry(fEntry).isSuccess()) {
                return true;
            }
            lbsLogger.error("Error in installing flow entry to node : {}", (Object)sourceSwitch);
        } else {
            lbsLogger.error("Conflicting flow entry exists : {}", (Object)fEntry.toString());
        }
        return false;
    }

    void init(Component c) {
        Dictionary props = c.getServiceProperties();
        if (props != null) {
            this.containerName = (String)props.get("containerName");
            lbsLogger.trace("Running container name:" + this.containerName);
        } else {
            this.containerName = "";
        }
        lbsLogger.trace(configManager.toString());
    }

    void destroy() {
    }

    void start() {
    }

    void stop() {
    }

    @Override
    public Set<VIP> getAllVIPs() {
        return configManager.getAllVIPs();
    }

    @Override
    public boolean vipExists(String name, String ip, String protocol, short protocolPort, String poolName) {
        return configManager.vipExists(name, ip, protocol, protocolPort, poolName);
    }

    @Override
    public boolean vipExists(VIP vip) {
        return configManager.vipExists(vip);
    }

    @Override
    public VIP createVIP(String name, String ip, String protocol, short protocolPort, String poolName) {
        return configManager.createVIP(name, ip, protocol, protocolPort, poolName);
    }

    @Override
    public VIP updateVIP(String name, String poolName) {
        return configManager.updateVIP(name, poolName);
    }

    @Override
    public VIP deleteVIP(String name) {
        return configManager.deleteVIP(name);
    }

    @Override
    public boolean memberExists(String name, String memberIP, String poolName) {
        return configManager.memberExists(name, memberIP, poolName);
    }

    @Override
    public Set<PoolMember> getAllPoolMembers(String poolName) {
        return configManager.getAllPoolMembers(poolName);
    }

    @Override
    public PoolMember addPoolMember(String name, String memberIP, String poolName) {
        return configManager.addPoolMember(name, memberIP, poolName);
    }

    @Override
    public PoolMember removePoolMember(String name, String poolName) {
        return configManager.removePoolMember(name, poolName);
    }

    @Override
    public Set<Pool> getAllPools() {
        return configManager.getAllPools();
    }

    @Override
    public Pool getPool(String poolName) {
        return configManager.getPool(poolName);
    }

    @Override
    public boolean poolExists(String name, String lbMethod) {
        return configManager.poolExists(name, lbMethod);
    }

    @Override
    public Pool createPool(String name, String lbMethod) {
        return configManager.createPool(name, lbMethod);
    }

    @Override
    public Pool deletePool(String poolName) {
        return configManager.deletePool(poolName);
    }

    @Override
    public boolean vipExists(String name) {
        return configManager.vipExists(name);
    }

    @Override
    public boolean memberExists(String name, String poolName) {
        return configManager.memberExists(name, poolName);
    }

    @Override
    public boolean poolExists(String name) {
        return configManager.poolExists(name);
    }

    @Override
    public String getVIPAttachedPool(String name) {
        return configManager.getVIPAttachedPool(name);
    }
}

