/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.samples.loadbalancer.policies;

import java.util.ArrayList;
import java.util.HashMap;
import org.opendaylight.controller.samples.loadbalancer.ConfigManager;
import org.opendaylight.controller.samples.loadbalancer.entities.Client;
import org.opendaylight.controller.samples.loadbalancer.entities.Pool;
import org.opendaylight.controller.samples.loadbalancer.entities.PoolMember;
import org.opendaylight.controller.samples.loadbalancer.entities.VIP;
import org.opendaylight.controller.samples.loadbalancer.policies.ILoadBalancingPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinLBPolicy
implements ILoadBalancingPolicy {
    private static final Logger rrLogger = LoggerFactory.getLogger(RoundRobinLBPolicy.class);
    private ConfigManager cmgr;
    private HashMap<Client, PoolMember> clientMemberMap;
    private HashMap<VIP, Integer> nextItemFromPool;

    private RoundRobinLBPolicy() {
    }

    public RoundRobinLBPolicy(ConfigManager cmgr) {
        this.cmgr = cmgr;
        this.clientMemberMap = new HashMap();
        this.nextItemFromPool = new HashMap();
    }

    @Override
    public String getPoolMemberForClient(Client source, VIP dest) {
        rrLogger.trace("Received traffic from client : {} for VIP : {} ", (Object)source, (Object)dest);
        this.syncWithLoadBalancerData();
        PoolMember pm = null;
        if (this.clientMemberMap.containsKey(source)) {
            pm = this.clientMemberMap.get(source);
            rrLogger.trace("Client {} had sent traffic before,new traffic will be routed to the same pool member {}", (Object)source, (Object)pm);
        } else {
            Pool pool = null;
            if (this.nextItemFromPool.containsKey(dest)) {
                int memberNum = this.nextItemFromPool.get(dest);
                rrLogger.debug("Packet is from new client for VIP {}", (Object)dest);
                pool = this.cmgr.getPool(dest.getPoolName());
                pm = pool.getAllMembers().get(memberNum);
                this.clientMemberMap.put(source, pm);
                rrLogger.trace("New client's packet will be directed to pool member {}", (Object)pm);
                if (++memberNum > pool.getAllMembers().size() - 1) {
                    memberNum = 0;
                }
                rrLogger.debug("Next pool member for new client of VIP is set to {}", (Object)pool.getAllMembers().get(memberNum));
                this.nextItemFromPool.put(dest, memberNum);
            } else {
                rrLogger.debug("Network traffic for VIP : {} has appeared first time from client {}", (Object)dest, (Object)source);
                pool = this.cmgr.getPool(dest.getPoolName());
                pm = pool.getAllMembers().get(0);
                this.clientMemberMap.put(source, pm);
                rrLogger.trace("Network traffic from client {} will be directed to pool member {}", (Object)pm);
                this.nextItemFromPool.put(dest, 1);
                rrLogger.debug("Next pool member for new client of VIP is set to {}", (Object)pool.getAllMembers().get(1));
            }
        }
        return pm.getIp();
    }

    private void syncWithLoadBalancerData() {
        rrLogger.debug("[Client - PoolMember] table before cleanup : {}", (Object)this.clientMemberMap.toString());
        ArrayList<Client> removeClient = new ArrayList<Client>();
        if (this.clientMemberMap.size() != 0) {
            for (Client client : this.clientMemberMap.keySet()) {
                if (this.cmgr.memberExists(this.clientMemberMap.get(client).getName(), this.clientMemberMap.get(client).getPoolName())) continue;
                removeClient.add(client);
            }
        }
        for (Client client : removeClient) {
            this.clientMemberMap.remove(client);
            rrLogger.debug("Removed client : {} ", (Object)client);
        }
        rrLogger.debug("[Client - PoolMember] table after cleanup : {}", (Object)this.clientMemberMap.toString());
        rrLogger.debug("[VIP- NextMember] table before cleanup : {}", (Object)this.nextItemFromPool.toString());
        ArrayList<VIP> resetVIPPoolMemberCount = new ArrayList<VIP>();
        if (this.nextItemFromPool.size() != 0) {
            for (VIP vip : this.nextItemFromPool.keySet()) {
                if (this.nextItemFromPool.get(vip) <= this.cmgr.getPool(vip.getPoolName()).getAllMembers().size() - 1) continue;
                resetVIPPoolMemberCount.add(vip);
            }
        }
        for (VIP vip : resetVIPPoolMemberCount) {
            rrLogger.debug("VIP next pool member counter reset to 0");
            this.nextItemFromPool.put(vip, 0);
        }
        rrLogger.debug("[VIP- NextMember] table after cleanup : {}", (Object)this.nextItemFromPool.toString());
    }
}

