/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.car.people;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.car.people.CarPerson;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.car.people.CarPersonKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.PersonId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CarPersonBuilder
implements Builder<CarPerson> {
    private CarId _carId;
    private CarPersonKey _key;
    private PersonId _personId;
    Map<Class<? extends Augmentation<CarPerson>>, Augmentation<CarPerson>> augmentation = Collections.emptyMap();

    public CarPersonBuilder() {
    }

    public CarPersonBuilder(CarPerson base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new CarPersonKey(base.getCarId(), base.getPersonId());
            this._carId = base.getCarId();
            this._personId = base.getPersonId();
        } else {
            this._key = base.getKey();
            this._carId = this._key.getCarId();
            this._personId = this._key.getPersonId();
        }
        if (base instanceof CarPersonImpl) {
            CarPersonImpl impl = (CarPersonImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<CarPerson>>, Augmentation<CarPerson>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CarPerson>>, Augmentation<CarPerson>>(casted.augmentations());
        }
    }

    public CarId getCarId() {
        return this._carId;
    }

    public CarPersonKey getKey() {
        return this._key;
    }

    public PersonId getPersonId() {
        return this._personId;
    }

    public <E extends Augmentation<CarPerson>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public CarPersonBuilder setCarId(CarId value) {
        this._carId = value;
        return this;
    }

    public CarPersonBuilder setKey(CarPersonKey value) {
        this._key = value;
        return this;
    }

    public CarPersonBuilder setPersonId(PersonId value) {
        this._personId = value;
        return this;
    }

    public CarPersonBuilder addAugmentation(Class<? extends Augmentation<CarPerson>> augmentationType, Augmentation<CarPerson> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CarPerson>>, Augmentation<CarPerson>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public CarPersonBuilder removeAugmentation(Class<? extends Augmentation<CarPerson>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public CarPerson build() {
        return new CarPersonImpl(this);
    }

    private static final class CarPersonImpl
    implements CarPerson {
        private final CarId _carId;
        private final CarPersonKey _key;
        private final PersonId _personId;
        private Map<Class<? extends Augmentation<CarPerson>>, Augmentation<CarPerson>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<CarPerson> getImplementedInterface() {
            return CarPerson.class;
        }

        private CarPersonImpl(CarPersonBuilder base) {
            if (base.getKey() == null) {
                this._key = new CarPersonKey(base.getCarId(), base.getPersonId());
                this._carId = base.getCarId();
                this._personId = base.getPersonId();
            } else {
                this._key = base.getKey();
                this._carId = this._key.getCarId();
                this._personId = this._key.getPersonId();
            }
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<CarPerson>>, Augmentation<CarPerson>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<CarPerson>>, Augmentation<CarPerson>>(base.augmentation);
                }
            }
        }

        @Override
        public CarId getCarId() {
            return this._carId;
        }

        @Override
        public CarPersonKey getKey() {
            return this._key;
        }

        @Override
        public PersonId getPersonId() {
            return this._personId;
        }

        public <E extends Augmentation<CarPerson>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._carId);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._personId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CarPerson.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            CarPerson other = (CarPerson)obj;
            if (!Objects.equals(this._carId, other.getCarId())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._personId, other.getPersonId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CarPersonImpl otherImpl = (CarPersonImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<CarPerson>>, Augmentation<CarPerson>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "CarPerson [";
            StringBuilder builder = new StringBuilder(name);
            if (this._carId != null) {
                builder.append("_carId=");
                builder.append(this._carId);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._personId != null) {
                builder.append("_personId=");
                builder.append(this._personId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

