/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.StressTestInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StressTestInputBuilder
implements Builder<StressTestInput> {
    private Long _count;
    private Integer _rate;
    Map<Class<? extends Augmentation<StressTestInput>>, Augmentation<StressTestInput>> augmentation = Collections.emptyMap();

    public StressTestInputBuilder() {
    }

    public StressTestInputBuilder(StressTestInput base) {
        AugmentationHolder casted;
        this._count = base.getCount();
        this._rate = base.getRate();
        if (base instanceof StressTestInputImpl) {
            StressTestInputImpl impl = (StressTestInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<StressTestInput>>, Augmentation<StressTestInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StressTestInput>>, Augmentation<StressTestInput>>(casted.augmentations());
        }
    }

    public Long getCount() {
        return this._count;
    }

    public Integer getRate() {
        return this._rate;
    }

    public <E extends Augmentation<StressTestInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public StressTestInputBuilder setCount(Long value) {
        if (value != null) {
            StressTestInputBuilder.checkCountRange(value);
        }
        this._count = value;
        return this;
    }

    private static void checkRateRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public StressTestInputBuilder setRate(Integer value) {
        if (value != null) {
            StressTestInputBuilder.checkRateRange(value);
        }
        this._rate = value;
        return this;
    }

    public StressTestInputBuilder addAugmentation(Class<? extends Augmentation<StressTestInput>> augmentationType, Augmentation<StressTestInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StressTestInput>>, Augmentation<StressTestInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public StressTestInputBuilder removeAugmentation(Class<? extends Augmentation<StressTestInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public StressTestInput build() {
        return new StressTestInputImpl(this);
    }

    private static final class StressTestInputImpl
    implements StressTestInput {
        private final Long _count;
        private final Integer _rate;
        private Map<Class<? extends Augmentation<StressTestInput>>, Augmentation<StressTestInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<StressTestInput> getImplementedInterface() {
            return StressTestInput.class;
        }

        private StressTestInputImpl(StressTestInputBuilder base) {
            this._count = base.getCount();
            this._rate = base.getRate();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<StressTestInput>>, Augmentation<StressTestInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<StressTestInput>>, Augmentation<StressTestInput>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getCount() {
            return this._count;
        }

        @Override
        public Integer getRate() {
            return this._rate;
        }

        public <E extends Augmentation<StressTestInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._count);
            result = 31 * result + Objects.hashCode(this._rate);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!StressTestInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            StressTestInput other = (StressTestInput)obj;
            if (!Objects.equals(this._count, other.getCount())) {
                return false;
            }
            if (!Objects.equals(this._rate, other.getRate())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StressTestInputImpl otherImpl = (StressTestInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<StressTestInput>>, Augmentation<StressTestInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "StressTestInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._count != null) {
                builder.append("_count=");
                builder.append(this._count);
                builder.append(", ");
            }
            if (this._rate != null) {
                builder.append("_rate=");
                builder.append(this._rate);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

