/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.cars;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.cars.CarEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.cars.CarEntryKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CarEntryBuilder
implements Builder<CarEntry> {
    private String _category;
    private CarId _id;
    private CarEntryKey _key;
    private String _manufacturer;
    private String _model;
    private Long _year;
    Map<Class<? extends Augmentation<CarEntry>>, Augmentation<CarEntry>> augmentation = Collections.emptyMap();

    public CarEntryBuilder() {
    }

    public CarEntryBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarEntry arg) {
        this._id = arg.getId();
        this._model = arg.getModel();
        this._manufacturer = arg.getManufacturer();
        this._year = arg.getYear();
        this._category = arg.getCategory();
    }

    public CarEntryBuilder(CarEntry base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new CarEntryKey(base.getId());
            this._id = base.getId();
        } else {
            this._key = base.getKey();
            this._id = this._key.getId();
        }
        this._category = base.getCategory();
        this._manufacturer = base.getManufacturer();
        this._model = base.getModel();
        this._year = base.getYear();
        if (base instanceof CarEntryImpl) {
            CarEntryImpl impl = (CarEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<CarEntry>>, Augmentation<CarEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CarEntry>>, Augmentation<CarEntry>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarEntry) {
            this._id = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarEntry)arg).getId();
            this._model = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarEntry)arg).getModel();
            this._manufacturer = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarEntry)arg).getManufacturer();
            this._year = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarEntry)arg).getYear();
            this._category = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarEntry)arg).getCategory();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarEntry] \nbut was: " + arg);
        }
    }

    public String getCategory() {
        return this._category;
    }

    public CarId getId() {
        return this._id;
    }

    public CarEntryKey getKey() {
        return this._key;
    }

    public String getManufacturer() {
        return this._manufacturer;
    }

    public String getModel() {
        return this._model;
    }

    public Long getYear() {
        return this._year;
    }

    public <E extends Augmentation<CarEntry>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public CarEntryBuilder setCategory(String value) {
        this._category = value;
        return this;
    }

    public CarEntryBuilder setId(CarId value) {
        this._id = value;
        return this;
    }

    public CarEntryBuilder setKey(CarEntryKey value) {
        this._key = value;
        return this;
    }

    public CarEntryBuilder setManufacturer(String value) {
        this._manufacturer = value;
        return this;
    }

    public CarEntryBuilder setModel(String value) {
        this._model = value;
        return this;
    }

    private static void checkYearRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public CarEntryBuilder setYear(Long value) {
        if (value != null) {
            CarEntryBuilder.checkYearRange(value);
        }
        this._year = value;
        return this;
    }

    public CarEntryBuilder addAugmentation(Class<? extends Augmentation<CarEntry>> augmentationType, Augmentation<CarEntry> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CarEntry>>, Augmentation<CarEntry>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public CarEntryBuilder removeAugmentation(Class<? extends Augmentation<CarEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public CarEntry build() {
        return new CarEntryImpl(this);
    }

    private static final class CarEntryImpl
    implements CarEntry {
        private final String _category;
        private final CarId _id;
        private final CarEntryKey _key;
        private final String _manufacturer;
        private final String _model;
        private final Long _year;
        private Map<Class<? extends Augmentation<CarEntry>>, Augmentation<CarEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<CarEntry> getImplementedInterface() {
            return CarEntry.class;
        }

        private CarEntryImpl(CarEntryBuilder base) {
            if (base.getKey() == null) {
                this._key = new CarEntryKey(base.getId());
                this._id = base.getId();
            } else {
                this._key = base.getKey();
                this._id = this._key.getId();
            }
            this._category = base.getCategory();
            this._manufacturer = base.getManufacturer();
            this._model = base.getModel();
            this._year = base.getYear();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<CarEntry>>, Augmentation<CarEntry>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<CarEntry>>, Augmentation<CarEntry>>(base.augmentation);
                }
            }
        }

        @Override
        public String getCategory() {
            return this._category;
        }

        @Override
        public CarId getId() {
            return this._id;
        }

        @Override
        public CarEntryKey getKey() {
            return this._key;
        }

        @Override
        public String getManufacturer() {
            return this._manufacturer;
        }

        @Override
        public String getModel() {
            return this._model;
        }

        @Override
        public Long getYear() {
            return this._year;
        }

        public <E extends Augmentation<CarEntry>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._category);
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._manufacturer);
            result = 31 * result + Objects.hashCode(this._model);
            result = 31 * result + Objects.hashCode(this._year);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CarEntry.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            CarEntry other = (CarEntry)obj;
            if (!Objects.equals(this._category, other.getCategory())) {
                return false;
            }
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._manufacturer, other.getManufacturer())) {
                return false;
            }
            if (!Objects.equals(this._model, other.getModel())) {
                return false;
            }
            if (!Objects.equals(this._year, other.getYear())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CarEntryImpl otherImpl = (CarEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<CarEntry>>, Augmentation<CarEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "CarEntry [";
            StringBuilder builder = new StringBuilder(name);
            if (this._category != null) {
                builder.append("_category=");
                builder.append(this._category);
                builder.append(", ");
            }
            if (this._id != null) {
                builder.append("_id=");
                builder.append(this._id);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._manufacturer != null) {
                builder.append("_manufacturer=");
                builder.append(this._manufacturer);
                builder.append(", ");
            }
            if (this._model != null) {
                builder.append("_model=");
                builder.append(this._model);
                builder.append(", ");
            }
            if (this._year != null) {
                builder.append("_year=");
                builder.append(this._year);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

