/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.config.toaster_provider.impl;

import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.config.toaster_provider.impl.AbstractToasterProviderModule;
import org.opendaylight.controller.config.yang.config.toaster_provider.impl.ToasterProviderRuntimeRegistration;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sample.toaster.provider.OpendaylightToaster;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToasterProviderModule
extends AbstractToasterProviderModule {
    private static final Logger log = LoggerFactory.getLogger(ToasterProviderModule.class);

    public ToasterProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public ToasterProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, ToasterProviderModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    protected void customValidation() {
    }

    @Override
    public AutoCloseable createInstance() {
        final OpendaylightToaster opendaylightToaster = new OpendaylightToaster();
        opendaylightToaster.setNotificationProvider(this.getNotificationServiceDependency());
        DataBroker dataBrokerService = this.getDataBrokerDependency();
        opendaylightToaster.setDataProvider(dataBrokerService);
        final ListenerRegistration dataChangeListenerRegistration = dataBrokerService.registerDataChangeListener(LogicalDatastoreType.CONFIGURATION, OpendaylightToaster.TOASTER_IID, (DataChangeListener)opendaylightToaster, AsyncDataBroker.DataChangeScope.SUBTREE);
        final BindingAwareBroker.RpcRegistration rpcRegistration = this.getRpcRegistryDependency().addRpcImplementation(ToasterService.class, (RpcService)opendaylightToaster);
        final ToasterProviderRuntimeRegistration runtimeReg = this.getRootRuntimeBeanRegistratorWrapper().register(opendaylightToaster);
        final class AutoCloseableToaster
        implements AutoCloseable {
            AutoCloseableToaster() {
            }

            @Override
            public void close() throws Exception {
                dataChangeListenerRegistration.close();
                rpcRegistration.close();
                runtimeReg.close();
                this.closeQuietly(opendaylightToaster);
                log.info("Toaster provider (instance {}) torn down.", (Object)this);
            }

            private void closeQuietly(AutoCloseable resource) {
                try {
                    resource.close();
                }
                catch (Exception e) {
                    log.debug("Ignoring exception while closing {}", (Object)resource, (Object)e);
                }
            }
        }
        AutoCloseableToaster ret = new AutoCloseableToaster();
        log.info("Toaster provider (instance {}) initialized.", (Object)ret);
        return ret;
    }
}

