/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sample.toaster.provider;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.controller.config.yang.config.toaster_provider.impl.ToasterProviderRuntimeMXBean;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.binding.api.ReadWriteTransaction;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.OptimisticLockFailedException;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.DisplayString;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastInput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.RestockToasterInput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.Toaster;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterOutOfBreadBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterRestocked;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterRestockedBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterService;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpendaylightToaster
implements ToasterService,
ToasterProviderRuntimeMXBean,
DataChangeListener,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(OpendaylightToaster.class);
    public static final InstanceIdentifier<Toaster> TOASTER_IID = InstanceIdentifier.builder(Toaster.class).build();
    private static final DisplayString TOASTER_MANUFACTURER = new DisplayString("Opendaylight");
    private static final DisplayString TOASTER_MODEL_NUMBER = new DisplayString("Model 1 - Binding Aware");
    private NotificationProviderService notificationProvider;
    private DataBroker dataProvider;
    private final ExecutorService executor;
    private final AtomicReference<Future<?>> currentMakeToastTask = new AtomicReference();
    private final AtomicLong amountOfBreadInStock = new AtomicLong(100L);
    private final AtomicLong toastsMade = new AtomicLong(0L);
    private final AtomicLong darknessFactor = new AtomicLong(1000L);

    public OpendaylightToaster() {
        this.executor = Executors.newFixedThreadPool(1);
    }

    public void setNotificationProvider(NotificationProviderService salService) {
        this.notificationProvider = salService;
    }

    public void setDataProvider(DataBroker salDataProvider) {
        this.dataProvider = salDataProvider;
        this.setToasterStatusUp(null);
    }

    @Override
    public void close() throws ExecutionException, InterruptedException {
        this.executor.shutdown();
        if (this.dataProvider != null) {
            WriteTransaction tx = this.dataProvider.newWriteOnlyTransaction();
            tx.delete(LogicalDatastoreType.OPERATIONAL, TOASTER_IID);
            Futures.addCallback((ListenableFuture)tx.submit(), (FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(Void result) {
                    LOG.debug("Delete Toaster commit result: " + result);
                }

                public void onFailure(Throwable t) {
                    LOG.error("Delete of Toaster failed", t);
                }
            });
        }
    }

    private Toaster buildToaster(Toaster.ToasterStatus status) {
        return new ToasterBuilder().setToasterManufacturer(TOASTER_MANUFACTURER).setToasterModelNumber(TOASTER_MODEL_NUMBER).setToasterStatus(status).build();
    }

    public void onDataChanged(AsyncDataChangeEvent<InstanceIdentifier<?>, DataObject> change) {
        DataObject dataObject = (DataObject)change.getUpdatedSubtree();
        if (dataObject instanceof Toaster) {
            Toaster toaster = (Toaster)dataObject;
            Long darkness = toaster.getDarknessFactor();
            if (darkness != null) {
                this.darknessFactor.set(darkness);
            }
            LOG.info("onDataChanged - new Toaster config: {}", (Object)toaster);
        }
    }

    public Future<RpcResult<Void>> cancelToast() {
        Future current = this.currentMakeToastTask.getAndSet(null);
        if (current != null) {
            current.cancel(true);
        }
        return Futures.immediateFuture((Object)RpcResultBuilder.success().build());
    }

    public Future<RpcResult<Void>> makeToast(MakeToastInput input) {
        LOG.info("makeToast: " + input);
        SettableFuture futureResult = SettableFuture.create();
        this.checkStatusAndMakeToast(input, (SettableFuture<RpcResult<Void>>)futureResult, 2);
        return futureResult;
    }

    private RpcError makeToasterOutOfBreadError() {
        return RpcResultBuilder.newError((RpcError.ErrorType)RpcError.ErrorType.APPLICATION, (String)"resource-denied", (String)"Toaster is out of bread", (String)"out-of-stock", null, null);
    }

    private RpcError makeToasterInUseError() {
        return RpcResultBuilder.newWarning((RpcError.ErrorType)RpcError.ErrorType.APPLICATION, (String)"in-use", (String)"Toaster is busy", null, null, null);
    }

    private void checkStatusAndMakeToast(final MakeToastInput input, final SettableFuture<RpcResult<Void>> futureResult, final int tries) {
        final ReadWriteTransaction tx = this.dataProvider.newReadWriteTransaction();
        CheckedFuture readFuture = tx.read(LogicalDatastoreType.OPERATIONAL, TOASTER_IID);
        ListenableFuture commitFuture = Futures.transform((ListenableFuture)readFuture, (AsyncFunction)new AsyncFunction<Optional<Toaster>, Void>(){

            public ListenableFuture<Void> apply(Optional<Toaster> toasterData) throws Exception {
                Toaster.ToasterStatus toasterStatus = Toaster.ToasterStatus.Up;
                if (toasterData.isPresent()) {
                    toasterStatus = ((Toaster)toasterData.get()).getToasterStatus();
                }
                LOG.debug("Read toaster status: {}", (Object)toasterStatus);
                if (toasterStatus == Toaster.ToasterStatus.Up) {
                    if (OpendaylightToaster.this.outOfBread()) {
                        LOG.debug("Toaster is out of bread");
                        return Futures.immediateFailedCheckedFuture((Exception)new TransactionCommitFailedException("", new RpcError[]{OpendaylightToaster.this.makeToasterOutOfBreadError()}));
                    }
                    LOG.debug("Setting Toaster status to Down");
                    tx.put(LogicalDatastoreType.OPERATIONAL, TOASTER_IID, (DataObject)OpendaylightToaster.this.buildToaster(Toaster.ToasterStatus.Down));
                    return tx.submit();
                }
                LOG.debug("Oops - already making toast!");
                return Futures.immediateFailedCheckedFuture((Exception)new TransactionCommitFailedException("", new RpcError[]{OpendaylightToaster.this.makeToasterInUseError()}));
            }
        });
        Futures.addCallback((ListenableFuture)commitFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                OpendaylightToaster.this.currentMakeToastTask.set(OpendaylightToaster.this.executor.submit(new MakeToastTask(input, (SettableFuture<RpcResult<Void>>)futureResult)));
            }

            public void onFailure(Throwable ex) {
                if (ex instanceof OptimisticLockFailedException) {
                    if (tries - 1 > 0) {
                        LOG.debug("Got OptimisticLockFailedException - trying again");
                        OpendaylightToaster.this.checkStatusAndMakeToast(input, (SettableFuture<RpcResult<Void>>)futureResult, tries - 1);
                    } else {
                        futureResult.set((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, ex.getMessage()).build());
                    }
                } else {
                    LOG.debug("Failed to commit Toaster status", ex);
                    futureResult.set((Object)RpcResultBuilder.failed().withRpcErrors((Collection)((TransactionCommitFailedException)ex).getErrorList()).build());
                }
            }
        });
    }

    public Future<RpcResult<Void>> restockToaster(RestockToasterInput input) {
        LOG.info("restockToaster: " + input);
        this.amountOfBreadInStock.set(input.getAmountOfBreadToStock());
        if (this.amountOfBreadInStock.get() > 0L) {
            ToasterRestocked reStockedNotification = new ToasterRestockedBuilder().setAmountOfBread(input.getAmountOfBreadToStock()).build();
            this.notificationProvider.publish((Notification)reStockedNotification);
        }
        return Futures.immediateFuture((Object)RpcResultBuilder.success().build());
    }

    @Override
    public void clearToastsMade() {
        LOG.info("clearToastsMade");
        this.toastsMade.set(0L);
    }

    @Override
    public Long getToastsMade() {
        return this.toastsMade.get();
    }

    private void setToasterStatusUp(final Function<Boolean, Void> resultCallback) {
        WriteTransaction tx = this.dataProvider.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.OPERATIONAL, TOASTER_IID, (DataObject)this.buildToaster(Toaster.ToasterStatus.Up));
        Futures.addCallback((ListenableFuture)tx.submit(), (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                this.notifyCallback(true);
            }

            public void onFailure(Throwable t) {
                LOG.error("Failed to update toaster status", t);
                this.notifyCallback(false);
            }

            void notifyCallback(boolean result) {
                if (resultCallback != null) {
                    resultCallback.apply((Object)result);
                }
            }
        });
    }

    private boolean outOfBread() {
        return this.amountOfBreadInStock.get() == 0L;
    }

    private class MakeToastTask
    implements Callable<Void> {
        final MakeToastInput toastRequest;
        final SettableFuture<RpcResult<Void>> futureResult;

        public MakeToastTask(MakeToastInput toastRequest, SettableFuture<RpcResult<Void>> futureResult) {
            this.toastRequest = toastRequest;
            this.futureResult = futureResult;
        }

        @Override
        public Void call() {
            try {
                long darknessFactor = OpendaylightToaster.this.darknessFactor.get();
                Thread.sleep(darknessFactor * this.toastRequest.getToasterDoneness());
            }
            catch (InterruptedException e) {
                LOG.info("Interrupted while making the toast");
            }
            OpendaylightToaster.this.toastsMade.incrementAndGet();
            OpendaylightToaster.this.amountOfBreadInStock.getAndDecrement();
            if (OpendaylightToaster.this.outOfBread()) {
                LOG.info("Toaster is out of bread!");
                OpendaylightToaster.this.notificationProvider.publish((Notification)new ToasterOutOfBreadBuilder().build());
            }
            OpendaylightToaster.this.setToasterStatusUp((Function<Boolean, Void>)((Function)new Function<Boolean, Void>(){

                public Void apply(Boolean result) {
                    OpendaylightToaster.this.currentMakeToastTask.set(null);
                    LOG.debug("Toast done");
                    MakeToastTask.this.futureResult.set((Object)RpcResultBuilder.success().build());
                    return null;
                }
            }));
            return null;
        }
    }
}

