/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sample.toaster.provider;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.opendaylight.controller.md.sal.common.util.jmx.AbstractMXBean;
import org.opendaylight.controller.sample.toaster.provider.ToasterProviderRuntimeMXBean;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.api.ReadWriteTransaction;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.OptimisticLockFailedException;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.CancelToastInput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.CancelToastOutput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.CancelToastOutputBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.DisplayString;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastInput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastOutput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastOutputBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.RestockToasterInput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.RestockToasterOutput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.RestockToasterOutputBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.Toaster;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterOutOfBreadBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterRestocked;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterRestockedBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.toaster.app.config.rev160503.ToasterAppConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.toaster.app.config.rev160503.ToasterAppConfigBuilder;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpendaylightToaster
extends AbstractMXBean
implements ToasterService,
ToasterProviderRuntimeMXBean,
DataTreeChangeListener<Toaster>,
AutoCloseable {
    private static final CancelToastOutput EMPTY_CANCEL_OUTPUT = new CancelToastOutputBuilder().build();
    private static final MakeToastOutput EMPTY_MAKE_OUTPUT = new MakeToastOutputBuilder().build();
    private static final RestockToasterOutput EMPTY_RESTOCK_OUTPUT = new RestockToasterOutputBuilder().build();
    private static final Logger LOG = LoggerFactory.getLogger(OpendaylightToaster.class);
    private static final InstanceIdentifier<Toaster> TOASTER_IID = InstanceIdentifier.builder(Toaster.class).build();
    private static final DisplayString TOASTER_MANUFACTURER = new DisplayString("Opendaylight");
    private static final DisplayString TOASTER_MODEL_NUMBER = new DisplayString("Model 1 - Binding Aware");
    private DataBroker dataBroker;
    private NotificationPublishService notificationProvider;
    private ListenerRegistration<OpendaylightToaster> dataTreeChangeListenerRegistration;
    private final ExecutorService executor;
    private final AtomicReference<Future<?>> currentMakeToastTask = new AtomicReference();
    private final AtomicLong amountOfBreadInStock = new AtomicLong(100L);
    private final AtomicLong toastsMade = new AtomicLong(0L);
    private final AtomicLong darknessFactor = new AtomicLong(1000L);
    private final ToasterAppConfig toasterAppConfig;

    public OpendaylightToaster() {
        this(new ToasterAppConfigBuilder().setManufacturer(TOASTER_MANUFACTURER).setModelNumber(TOASTER_MODEL_NUMBER).setMaxMakeToastTries(2).build());
    }

    public OpendaylightToaster(ToasterAppConfig toasterAppConfig) {
        super("OpendaylightToaster", "toaster-provider", null);
        this.executor = Executors.newFixedThreadPool(1);
        this.toasterAppConfig = toasterAppConfig;
    }

    public void setNotificationProvider(NotificationPublishService notificationPublishService) {
        this.notificationProvider = notificationPublishService;
    }

    public void setDataBroker(DataBroker dataBroker) {
        this.dataBroker = dataBroker;
    }

    public void init() {
        LOG.info("Initializing...");
        this.dataTreeChangeListenerRegistration = Objects.requireNonNull(this.dataBroker, "dataBroker must be set").registerDataTreeChangeListener(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, TOASTER_IID), (DataTreeChangeListener)this);
        this.setToasterStatusUp(null);
        this.register();
    }

    @Override
    public void close() {
        LOG.info("Closing...");
        this.unregister();
        this.executor.shutdown();
        if (this.dataTreeChangeListenerRegistration != null) {
            this.dataTreeChangeListenerRegistration.close();
        }
        if (this.dataBroker != null) {
            WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
            tx.delete(LogicalDatastoreType.OPERATIONAL, TOASTER_IID);
            Futures.addCallback((ListenableFuture)tx.commit(), (FutureCallback)new FutureCallback<CommitInfo>(){

                public void onSuccess(CommitInfo result) {
                    LOG.debug("Successfully deleted the operational Toaster");
                }

                public void onFailure(Throwable failure) {
                    LOG.error("Delete of the operational Toaster failed", failure);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }

    private Toaster buildToaster(Toaster.ToasterStatus status) {
        return new ToasterBuilder().setToasterManufacturer(this.toasterAppConfig.getManufacturer()).setToasterModelNumber(this.toasterAppConfig.getModelNumber()).setToasterStatus(status).build();
    }

    public void onDataTreeChanged(Collection<DataTreeModification<Toaster>> changes) {
        for (DataTreeModification<Toaster> change : changes) {
            DataObjectModification rootNode = change.getRootNode();
            if (rootNode.getModificationType() == DataObjectModification.ModificationType.WRITE) {
                Toaster oldToaster = (Toaster)rootNode.getDataBefore();
                Toaster newToaster = (Toaster)rootNode.getDataAfter();
                LOG.info("onDataTreeChanged - Toaster config with path {} was added or replaced: old Toaster: {}, new Toaster: {}", new Object[]{change.getRootPath().getRootIdentifier(), oldToaster, newToaster});
                Long darkness = newToaster.getDarknessFactor();
                if (darkness == null) continue;
                this.darknessFactor.set(darkness);
                continue;
            }
            if (rootNode.getModificationType() != DataObjectModification.ModificationType.DELETE) continue;
            LOG.info("onDataTreeChanged - Toaster config with path {} was deleted: old Toaster: {}", (Object)change.getRootPath().getRootIdentifier(), (Object)rootNode.getDataBefore());
        }
    }

    public ListenableFuture<RpcResult<CancelToastOutput>> cancelToast(CancelToastInput input) {
        Future current = this.currentMakeToastTask.getAndSet(null);
        if (current != null) {
            current.cancel(true);
        }
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)EMPTY_CANCEL_OUTPUT).build());
    }

    public ListenableFuture<RpcResult<MakeToastOutput>> makeToast(MakeToastInput input) {
        LOG.info("makeToast: {}", (Object)input);
        SettableFuture futureResult = SettableFuture.create();
        this.checkStatusAndMakeToast(input, (SettableFuture<RpcResult<MakeToastOutput>>)futureResult, this.toasterAppConfig.getMaxMakeToastTries());
        return futureResult;
    }

    private static RpcError makeToasterOutOfBreadError() {
        return RpcResultBuilder.newError((RpcError.ErrorType)RpcError.ErrorType.APPLICATION, (String)"resource-denied", (String)"Toaster is out of bread", (String)"out-of-stock", null, null);
    }

    private static RpcError makeToasterInUseError() {
        return RpcResultBuilder.newWarning((RpcError.ErrorType)RpcError.ErrorType.APPLICATION, (String)"in-use", (String)"Toaster is busy", null, null, null);
    }

    private void checkStatusAndMakeToast(final MakeToastInput input, final SettableFuture<RpcResult<MakeToastOutput>> futureResult, final int tries) {
        ReadWriteTransaction tx = this.dataBroker.newReadWriteTransaction();
        FluentFuture readFuture = tx.read(LogicalDatastoreType.OPERATIONAL, TOASTER_IID);
        ListenableFuture commitFuture = Futures.transformAsync((ListenableFuture)readFuture, toasterData -> {
            Toaster.ToasterStatus toasterStatus = Toaster.ToasterStatus.Up;
            if (toasterData.isPresent()) {
                toasterStatus = ((Toaster)toasterData.get()).getToasterStatus();
            }
            LOG.debug("Read toaster status: {}", (Object)toasterStatus);
            if (toasterStatus == Toaster.ToasterStatus.Up) {
                if (this.outOfBread()) {
                    LOG.debug("Toaster is out of bread");
                    tx.cancel();
                    return Futures.immediateFailedFuture((Throwable)new TransactionCommitFailedException("", new RpcError[]{OpendaylightToaster.makeToasterOutOfBreadError()}));
                }
                LOG.debug("Setting Toaster status to Down");
                tx.put(LogicalDatastoreType.OPERATIONAL, TOASTER_IID, (DataObject)this.buildToaster(Toaster.ToasterStatus.Down));
                return tx.commit();
            }
            LOG.debug("Oops - already making toast!");
            tx.cancel();
            return Futures.immediateFailedFuture((Throwable)new TransactionCommitFailedException("", new RpcError[]{OpendaylightToaster.makeToasterInUseError()}));
        }, (Executor)MoreExecutors.directExecutor());
        Futures.addCallback((ListenableFuture)commitFuture, (FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                OpendaylightToaster.this.currentMakeToastTask.set(OpendaylightToaster.this.executor.submit(new MakeToastTask(input, (SettableFuture<RpcResult<MakeToastOutput>>)futureResult)));
            }

            public void onFailure(Throwable ex) {
                if (ex instanceof OptimisticLockFailedException) {
                    if (tries - 1 > 0) {
                        LOG.debug("Got OptimisticLockFailedException - trying again");
                        OpendaylightToaster.this.checkStatusAndMakeToast(input, (SettableFuture<RpcResult<MakeToastOutput>>)futureResult, tries - 1);
                    } else {
                        futureResult.set((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, ex.getMessage()).build());
                    }
                } else if (ex instanceof TransactionCommitFailedException) {
                    LOG.debug("Failed to commit Toaster status", ex);
                    futureResult.set((Object)RpcResultBuilder.failed().withRpcErrors((Collection)((TransactionCommitFailedException)ex).getErrorList()).build());
                } else {
                    LOG.debug("Unexpected error committing Toaster status", ex);
                    futureResult.set((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "Unexpected error committing Toaster status", ex).build());
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<RpcResult<RestockToasterOutput>> restockToaster(RestockToasterInput input) {
        LOG.info("restockToaster: {}", (Object)input);
        this.amountOfBreadInStock.set(input.getAmountOfBreadToStock());
        if (this.amountOfBreadInStock.get() > 0L) {
            ToasterRestocked reStockedNotification = new ToasterRestockedBuilder().setAmountOfBread(input.getAmountOfBreadToStock()).build();
            this.notificationProvider.offerNotification((Notification)reStockedNotification);
        }
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)EMPTY_RESTOCK_OUTPUT).build());
    }

    @Override
    public void clearToastsMade() {
        LOG.info("clearToastsMade");
        this.toastsMade.set(0L);
    }

    @Override
    public Long getToastsMade() {
        return this.toastsMade.get();
    }

    private void setToasterStatusUp(final Function<Boolean, MakeToastOutput> resultCallback) {
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.OPERATIONAL, TOASTER_IID, (DataObject)this.buildToaster(Toaster.ToasterStatus.Up));
        Futures.addCallback((ListenableFuture)tx.commit(), (FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.info("Successfully set ToasterStatus to Up");
                this.notifyCallback(true);
            }

            public void onFailure(Throwable failure) {
                LOG.error("Failed to update toaster status", failure);
                this.notifyCallback(false);
            }

            void notifyCallback(boolean result) {
                if (resultCallback != null) {
                    resultCallback.apply(result);
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private boolean outOfBread() {
        return this.amountOfBreadInStock.get() == 0L;
    }

    private class MakeToastTask
    implements Callable<Void> {
        final MakeToastInput toastRequest;
        final SettableFuture<RpcResult<MakeToastOutput>> futureResult;

        MakeToastTask(MakeToastInput toastRequest, SettableFuture<RpcResult<MakeToastOutput>> futureResult) {
            this.toastRequest = toastRequest;
            this.futureResult = futureResult;
        }

        @Override
        public Void call() {
            try {
                Thread.sleep(OpendaylightToaster.this.darknessFactor.get() * this.toastRequest.getToasterDoneness());
            }
            catch (InterruptedException e) {
                LOG.info("Interrupted while making the toast");
            }
            OpendaylightToaster.this.toastsMade.incrementAndGet();
            OpendaylightToaster.this.amountOfBreadInStock.getAndDecrement();
            if (OpendaylightToaster.this.outOfBread()) {
                LOG.info("Toaster is out of bread!");
                OpendaylightToaster.this.notificationProvider.offerNotification((Notification)new ToasterOutOfBreadBuilder().build());
            }
            OpendaylightToaster.this.setToasterStatusUp(result -> {
                OpendaylightToaster.this.currentMakeToastTask.set(null);
                LOG.debug("Toast done");
                this.futureResult.set((Object)RpcResultBuilder.success((Object)EMPTY_MAKE_OUTPUT).build());
                return null;
            });
            return null;
        }
    }
}

