/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.toaster.app.config.rev160503;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.DisplayString;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.toaster.app.config.rev160503.ToasterAppConfig;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ToasterAppConfigBuilder
implements Builder<ToasterAppConfig> {
    private DisplayString _manufacturer;
    private Integer _maxMakeToastTries;
    private DisplayString _modelNumber;
    Map<Class<? extends Augmentation<ToasterAppConfig>>, Augmentation<ToasterAppConfig>> augmentation = Collections.emptyMap();

    public ToasterAppConfigBuilder() {
    }

    public ToasterAppConfigBuilder(ToasterAppConfig base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ToasterAppConfig>>, Augmentation<ToasterAppConfig>>(aug);
        }
        this._manufacturer = base.getManufacturer();
        this._maxMakeToastTries = base.getMaxMakeToastTries();
        this._modelNumber = base.getModelNumber();
    }

    public DisplayString getManufacturer() {
        return this._manufacturer;
    }

    public Integer getMaxMakeToastTries() {
        return this._maxMakeToastTries;
    }

    public DisplayString getModelNumber() {
        return this._modelNumber;
    }

    public <E$$ extends Augmentation<ToasterAppConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ToasterAppConfigBuilder setManufacturer(DisplayString value) {
        this._manufacturer = value;
        return this;
    }

    private static void checkMaxMakeToastTriesRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public ToasterAppConfigBuilder setMaxMakeToastTries(Integer value) {
        if (value != null) {
            ToasterAppConfigBuilder.checkMaxMakeToastTriesRange(value);
        }
        this._maxMakeToastTries = value;
        return this;
    }

    public ToasterAppConfigBuilder setModelNumber(DisplayString value) {
        this._modelNumber = value;
        return this;
    }

    public ToasterAppConfigBuilder addAugmentation(Class<? extends Augmentation<ToasterAppConfig>> augmentationType, Augmentation<ToasterAppConfig> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ToasterAppConfig>>, Augmentation<ToasterAppConfig>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ToasterAppConfigBuilder removeAugmentation(Class<? extends Augmentation<ToasterAppConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ToasterAppConfig build() {
        return new ToasterAppConfigImpl(this);
    }

    private static final class ToasterAppConfigImpl
    extends AbstractAugmentable<ToasterAppConfig>
    implements ToasterAppConfig {
        private final DisplayString _manufacturer;
        private final Integer _maxMakeToastTries;
        private final DisplayString _modelNumber;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ToasterAppConfigImpl(ToasterAppConfigBuilder base) {
            super(base.augmentation);
            this._manufacturer = base.getManufacturer();
            this._maxMakeToastTries = base.getMaxMakeToastTries();
            this._modelNumber = base.getModelNumber();
        }

        @Override
        public DisplayString getManufacturer() {
            return this._manufacturer;
        }

        @Override
        public Integer getMaxMakeToastTries() {
            return this._maxMakeToastTries;
        }

        @Override
        public DisplayString getModelNumber() {
            return this._modelNumber;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._manufacturer);
            result = 31 * result + Objects.hashCode(this._maxMakeToastTries);
            result = 31 * result + Objects.hashCode(this._modelNumber);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ToasterAppConfig.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            ToasterAppConfig other = (ToasterAppConfig)obj;
            if (!Objects.equals(this._manufacturer, other.getManufacturer())) {
                return false;
            }
            if (!Objects.equals(this._maxMakeToastTries, other.getMaxMakeToastTries())) {
                return false;
            }
            if (!Objects.equals(this._modelNumber, other.getModelNumber())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ToasterAppConfigImpl otherImpl = (ToasterAppConfigImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"ToasterAppConfig");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_manufacturer", (Object)this._manufacturer);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maxMakeToastTries", (Object)this._maxMakeToastTries);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_modelNumber", (Object)this._modelNumber);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

