package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.toaster.app.config.rev160503;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.DisplayString;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>toaster-app-config</b>
 * <pre>
 * container toaster-app-config {
 *     leaf manufacturer {
 *         type manufacturer;
 *     }
 *     leaf model-number {
 *         type model-number;
 *     }
 *     leaf max-make-toast-tries {
 *         type max-make-toast-tries;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>toaster-app-config/toaster-app-config</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.toaster.app.config.rev160503.ToasterAppConfigBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.toaster.app.config.rev160503.ToasterAppConfigBuilder
 *
 */
public interface ToasterAppConfig
    extends
    ChildOf<ToasterAppConfigData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.toaster.app.config.rev160503.ToasterAppConfig>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:toaster-app-config",
        "2016-05-03", "toaster-app-config").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.DisplayString</code> <code>manufacturer</code>, or <code>null</code> if not present
     */
    DisplayString getManufacturer();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.DisplayString</code> <code>modelNumber</code>, or <code>null</code> if not present
     */
    DisplayString getModelNumber();
    
    /**
     * @return <code>java.lang.Integer</code> <code>maxMakeToastTries</code>, or <code>null</code> if not present
     */
    java.lang.Integer getMaxMakeToastTries();

}

