package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.toaster.app.config.rev160503;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * Configuration for the Opendaylight toaster application.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>toaster-app-config</b>
 * <pre>
 * module toaster-app-config {
 *     yang-version 1;
 *     namespace "urn:opendaylight:params:xml:ns:yang:controller:toaster-app-config";
 *     prefix "toaster-app-config";
 *
 *     import toaster { prefix "toaster"; }
 *     revision 2016-05-03 {
 *         description "Configuration for the Opendaylight toaster application.
 *         ";
 *     }
 *
 *     container toaster-app-config {
 *         leaf manufacturer {
 *             type manufacturer;
 *         }
 *         leaf model-number {
 *             type model-number;
 *         }
 *         leaf max-make-toast-tries {
 *             type max-make-toast-tries;
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface ToasterAppConfigData
    extends
    DataRoot
{




    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.toaster.app.config.rev160503.ToasterAppConfig</code> <code>toasterAppConfig</code>, or <code>null</code> if not present
     */
    ToasterAppConfig getToasterAppConfig();

}

