/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.toaster.app.config.rev160503;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.DisplayString;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.toaster.app.config.rev160503.ToasterAppConfig;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;

public class ToasterAppConfigBuilder
implements Builder<ToasterAppConfig> {
    private DisplayString _manufacturer;
    private Uint16 _maxMakeToastTries;
    private DisplayString _modelNumber;
    Map<Class<? extends Augmentation<ToasterAppConfig>>, Augmentation<ToasterAppConfig>> augmentation = Collections.emptyMap();

    public ToasterAppConfigBuilder() {
    }

    public ToasterAppConfigBuilder(ToasterAppConfig base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ToasterAppConfig>>, Augmentation<ToasterAppConfig>>(aug);
        }
        this._manufacturer = base.getManufacturer();
        this._maxMakeToastTries = base.getMaxMakeToastTries();
        this._modelNumber = base.getModelNumber();
    }

    public DisplayString getManufacturer() {
        return this._manufacturer;
    }

    public Uint16 getMaxMakeToastTries() {
        return this._maxMakeToastTries;
    }

    public DisplayString getModelNumber() {
        return this._modelNumber;
    }

    public <E$$ extends Augmentation<ToasterAppConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ToasterAppConfigBuilder setManufacturer(DisplayString value) {
        this._manufacturer = value;
        return this;
    }

    public ToasterAppConfigBuilder setMaxMakeToastTries(Uint16 value) {
        this._maxMakeToastTries = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public ToasterAppConfigBuilder setMaxMakeToastTries(Integer value) {
        return this.setMaxMakeToastTries(CodeHelpers.compatUint((Integer)value));
    }

    public ToasterAppConfigBuilder setModelNumber(DisplayString value) {
        this._modelNumber = value;
        return this;
    }

    public ToasterAppConfigBuilder addAugmentation(Augmentation<ToasterAppConfig> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ToasterAppConfig>>, Augmentation<ToasterAppConfig>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ToasterAppConfigBuilder removeAugmentation(Class<? extends Augmentation<ToasterAppConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ToasterAppConfig build() {
        return new ToasterAppConfigImpl(this);
    }

    private static final class ToasterAppConfigImpl
    extends AbstractAugmentable<ToasterAppConfig>
    implements ToasterAppConfig {
        private final DisplayString _manufacturer;
        private final Uint16 _maxMakeToastTries;
        private final DisplayString _modelNumber;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ToasterAppConfigImpl(ToasterAppConfigBuilder base) {
            super(base.augmentation);
            this._manufacturer = base.getManufacturer();
            this._maxMakeToastTries = base.getMaxMakeToastTries();
            this._modelNumber = base.getModelNumber();
        }

        @Override
        public DisplayString getManufacturer() {
            return this._manufacturer;
        }

        @Override
        public Uint16 getMaxMakeToastTries() {
            return this._maxMakeToastTries;
        }

        @Override
        public DisplayString getModelNumber() {
            return this._modelNumber;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = ToasterAppConfig.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return ToasterAppConfig.bindingEquals(this, obj);
        }

        public String toString() {
            return ToasterAppConfig.bindingToString(this);
        }
    }
}

