package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>toaster</b>
 * <pre>
 * input {
 *   leaf amountOfBreadToStock {
 *     type uint32;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>toaster/restock-toaster/input</i>
 *
 * <p>To create instances of this class use {@link RestockToasterInputBuilder}.
 * @see RestockToasterInputBuilder
 *
 */
public interface RestockToasterInput
    extends
    RpcInput,
    Augmentable<RestockToasterInput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.RestockToasterInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.RestockToasterInput.class;
    }
    
    /**
     * Indicates the amount of bread to re-stock
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>amountOfBreadToStock</code>, or <code>null</code> if not present
     */
    @Nullable Long getAmountOfBreadToStock();

}

