/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastInput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToastType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class MakeToastInputBuilder
implements Builder<MakeToastInput> {
    private Uint32 _toasterDoneness;
    private Class<? extends ToastType> _toasterToastType;
    Map<Class<? extends Augmentation<MakeToastInput>>, Augmentation<MakeToastInput>> augmentation = Collections.emptyMap();

    public MakeToastInputBuilder() {
    }

    public MakeToastInputBuilder(MakeToastInput base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MakeToastInput>>, Augmentation<MakeToastInput>>(aug);
        }
        this._toasterDoneness = base.getToasterDoneness();
        this._toasterToastType = base.getToasterToastType();
    }

    public Uint32 getToasterDoneness() {
        return this._toasterDoneness;
    }

    public Class<? extends ToastType> getToasterToastType() {
        return this._toasterToastType;
    }

    public <E$$ extends Augmentation<MakeToastInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkToasterDonenessRange(long value) {
        if (value >= 1L && value <= 10L) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..10]]", (long)value);
    }

    public MakeToastInputBuilder setToasterDoneness(Uint32 value) {
        if (value != null) {
            MakeToastInputBuilder.checkToasterDonenessRange(value.longValue());
        }
        this._toasterDoneness = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public MakeToastInputBuilder setToasterDoneness(Long value) {
        return this.setToasterDoneness(CodeHelpers.compatUint((Long)value));
    }

    public MakeToastInputBuilder setToasterToastType(Class<? extends ToastType> value) {
        this._toasterToastType = value;
        return this;
    }

    public MakeToastInputBuilder addAugmentation(Class<? extends Augmentation<MakeToastInput>> augmentationType, Augmentation<MakeToastInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MakeToastInput>>, Augmentation<MakeToastInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MakeToastInputBuilder removeAugmentation(Class<? extends Augmentation<MakeToastInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MakeToastInput build() {
        return new MakeToastInputImpl(this);
    }

    private static final class MakeToastInputImpl
    extends AbstractAugmentable<MakeToastInput>
    implements MakeToastInput {
        private final Uint32 _toasterDoneness;
        private final Class<? extends ToastType> _toasterToastType;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MakeToastInputImpl(MakeToastInputBuilder base) {
            super(base.augmentation);
            this._toasterDoneness = base.getToasterDoneness();
            this._toasterToastType = base.getToasterToastType();
        }

        @Override
        public Uint32 getToasterDoneness() {
            return this._toasterDoneness;
        }

        @Override
        public Class<? extends ToastType> getToasterToastType() {
            return this._toasterToastType;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._toasterDoneness);
            result = 31 * result + Objects.hashCode(this._toasterToastType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MakeToastInput.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            MakeToastInput other = (MakeToastInput)obj;
            if (!Objects.equals(this._toasterDoneness, other.getToasterDoneness())) {
                return false;
            }
            if (!Objects.equals(this._toasterToastType, other.getToasterToastType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MakeToastInputImpl otherImpl = (MakeToastInputImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"MakeToastInput");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_toasterDoneness", (Object)this._toasterDoneness);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_toasterToastType", this._toasterToastType);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

