/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.DisplayString;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.Toaster;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class ToasterBuilder
implements Builder<Toaster> {
    private Uint32 _darknessFactor;
    private DisplayString _toasterManufacturer;
    private DisplayString _toasterModelNumber;
    private Toaster.ToasterStatus _toasterStatus;
    Map<Class<? extends Augmentation<Toaster>>, Augmentation<Toaster>> augmentation = Collections.emptyMap();

    public ToasterBuilder() {
    }

    public ToasterBuilder(Toaster base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Toaster>>, Augmentation<Toaster>>(aug);
        }
        this._darknessFactor = base.getDarknessFactor();
        this._toasterManufacturer = base.getToasterManufacturer();
        this._toasterModelNumber = base.getToasterModelNumber();
        this._toasterStatus = base.getToasterStatus();
    }

    public Uint32 getDarknessFactor() {
        return this._darknessFactor;
    }

    public DisplayString getToasterManufacturer() {
        return this._toasterManufacturer;
    }

    public DisplayString getToasterModelNumber() {
        return this._toasterModelNumber;
    }

    public Toaster.ToasterStatus getToasterStatus() {
        return this._toasterStatus;
    }

    public <E$$ extends Augmentation<Toaster>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ToasterBuilder setDarknessFactor(Uint32 value) {
        this._darknessFactor = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public ToasterBuilder setDarknessFactor(Long value) {
        return this.setDarknessFactor(CodeHelpers.compatUint((Long)value));
    }

    public ToasterBuilder setToasterManufacturer(DisplayString value) {
        this._toasterManufacturer = value;
        return this;
    }

    public ToasterBuilder setToasterModelNumber(DisplayString value) {
        this._toasterModelNumber = value;
        return this;
    }

    public ToasterBuilder setToasterStatus(Toaster.ToasterStatus value) {
        this._toasterStatus = value;
        return this;
    }

    public ToasterBuilder addAugmentation(Augmentation<Toaster> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public ToasterBuilder addAugmentation(Class<? extends Augmentation<Toaster>> augmentationType, Augmentation<Toaster> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public ToasterBuilder removeAugmentation(Class<? extends Augmentation<Toaster>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private ToasterBuilder doAddAugmentation(Class<? extends Augmentation<Toaster>> augmentationType, Augmentation<Toaster> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Toaster>>, Augmentation<Toaster>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public Toaster build() {
        return new ToasterImpl(this);
    }

    private static final class ToasterImpl
    extends AbstractAugmentable<Toaster>
    implements Toaster {
        private final Uint32 _darknessFactor;
        private final DisplayString _toasterManufacturer;
        private final DisplayString _toasterModelNumber;
        private final Toaster.ToasterStatus _toasterStatus;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ToasterImpl(ToasterBuilder base) {
            super(base.augmentation);
            this._darknessFactor = base.getDarknessFactor();
            this._toasterManufacturer = base.getToasterManufacturer();
            this._toasterModelNumber = base.getToasterModelNumber();
            this._toasterStatus = base.getToasterStatus();
        }

        @Override
        public Uint32 getDarknessFactor() {
            return this._darknessFactor;
        }

        @Override
        public DisplayString getToasterManufacturer() {
            return this._toasterManufacturer;
        }

        @Override
        public DisplayString getToasterModelNumber() {
            return this._toasterModelNumber;
        }

        @Override
        public Toaster.ToasterStatus getToasterStatus() {
            return this._toasterStatus;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._darknessFactor);
            result = 31 * result + Objects.hashCode(this._toasterManufacturer);
            result = 31 * result + Objects.hashCode(this._toasterModelNumber);
            result = 31 * result + Objects.hashCode((Object)this._toasterStatus);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Toaster.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Toaster other = (Toaster)obj;
            if (!Objects.equals(this._darknessFactor, other.getDarknessFactor())) {
                return false;
            }
            if (!Objects.equals(this._toasterManufacturer, other.getToasterManufacturer())) {
                return false;
            }
            if (!Objects.equals(this._toasterModelNumber, other.getToasterModelNumber())) {
                return false;
            }
            if (!Objects.equals((Object)this._toasterStatus, (Object)other.getToasterStatus())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ToasterImpl otherImpl = (ToasterImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Toaster");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_darknessFactor", (Object)this._darknessFactor);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_toasterManufacturer", (Object)this._toasterManufacturer);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_toasterModelNumber", (Object)this._toasterModelNumber);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_toasterStatus", (Object)((Object)this._toasterStatus));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

