package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>toaster</b>
 * <pre>
 * rpc make-toast {
 *   input input {
 *     leaf toasterDoneness {
 *       type uint32 {
 *         range "1 .. 10";
 *       }
 *       default 5;
 *     }
 *     leaf toasterToastType {
 *       type identityref {
 *         base toast-type;
 *       }
 *       default wheat-bread;
 *     }
 *   }
 * }
 * rpc cancel-toast {
 * }
 * rpc restock-toaster {
 *   input input {
 *     leaf amountOfBreadToStock {
 *       type uint32;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface ToasterService
    extends
    RpcService
{




    /**
     * Invoke {@code make-toast} RPC.
     *
     * <pre>
     *     <code>
     *         Make some toast. The toastDone notification will be sent when the toast is
     *         finished. An 'in-use' error will be returned if toast is already being made. A
     *         'resource-denied' error will be returned if the toaster service is disabled.
     *     </code>
     * </pre>
     *
     *
     * @param input of {@code make-toast}
     * @return output of {@code make-toast}
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<MakeToastOutput>> makeToast(MakeToastInput input);
    
    /**
     * Invoke {@code cancel-toast} RPC.
     *
     * <pre>
     *     <code>
     *         Stop making toast, if any is being made. A 'resource-denied' error will be
     *         returned if the toaster service is disabled.
     *     </code>
     * </pre>
     *
     *
     * @param input of {@code cancel-toast}
     * @return output of {@code cancel-toast}
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<CancelToastOutput>> cancelToast(CancelToastInput input);
    
    /**
     * Invoke {@code restock-toaster} RPC.
     *
     * <pre>
     *     <code>
     *         Restocks the toaster with the amount of bread specified.
     *     </code>
     * </pre>
     *
     *
     * @param input of {@code restock-toaster}
     * @return output of {@code restock-toaster}
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<RestockToasterOutput>> restockToaster(RestockToasterInput input);

}

