package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Top-level container for all toaster database objects.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>toaster</b>
 * <pre>
 * container toaster {
 *   presence "Indicates the toaster service is available";
 *   leaf toasterManufacturer {
 *     type DisplayString;
 *     config false;
 *   }
 *   leaf toasterModelNumber {
 *     type DisplayString;
 *     config false;
 *   }
 *   leaf toasterStatus {
 *     type enumeration {
 *       enum up {
 *         value 1;
 *       }
 *       enum down {
 *         value 2;
 *       }
 *     }
 *     config false;
 *   }
 *   leaf darknessFactor {
 *     type uint32;
 *     default 1000;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>toastertoaster</i>
 *
 * <p>To create instances of this class use {@link ToasterBuilder}.
 * @see ToasterBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Toaster
    extends
    ChildOf<ToasterData>,
    Augmentable<Toaster>
{


    @Generated("mdsal-binding-generator")
    public enum ToasterStatus implements Enumeration {
        /**
         * The toaster knob position is up.
         *        No toast is being made now.
         */
        Up(1, "up"),
        
        /**
         * The toaster knob position is down.
         *        Toast is being made now.
         */
        Down(2, "down")
        ;
    
        private static final Map<String, ToasterStatus> NAME_MAP;
        private static final Map<Integer, ToasterStatus> VALUE_MAP;
    
        static {
            final Builder<String, ToasterStatus> nb = ImmutableMap.builder();
            final Builder<Integer, ToasterStatus> vb = ImmutableMap.builder();
            for (ToasterStatus enumItem : ToasterStatus.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private ToasterStatus(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding ToasterStatus item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<ToasterStatus> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding ToasterStatus item, or null if no such item exists
         */
        public static ToasterStatus forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("toaster");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.Toaster> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.Toaster.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.@NonNull Toaster obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getDarknessFactor());
        result = prime * result + Objects.hashCode(obj.getToasterManufacturer());
        result = prime * result + Objects.hashCode(obj.getToasterModelNumber());
        result = prime * result + Objects.hashCode(obj.getToasterStatus());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.@NonNull Toaster thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.Toaster other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.Toaster.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getDarknessFactor(), other.getDarknessFactor())) {
            return false;
        }
        if (!Objects.equals(thisObj.getToasterManufacturer(), other.getToasterManufacturer())) {
            return false;
        }
        if (!Objects.equals(thisObj.getToasterModelNumber(), other.getToasterModelNumber())) {
            return false;
        }
        if (!Objects.equals(thisObj.getToasterStatus(), other.getToasterStatus())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.@NonNull Toaster obj) {
        final var helper = MoreObjects.toStringHelper("Toaster");
        CodeHelpers.appendValue(helper, "darknessFactor", obj.getDarknessFactor());
        CodeHelpers.appendValue(helper, "toasterManufacturer", obj.getToasterManufacturer());
        CodeHelpers.appendValue(helper, "toasterModelNumber", obj.getToasterModelNumber());
        CodeHelpers.appendValue(helper, "toasterStatus", obj.getToasterStatus());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return toasterManufacturer, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The name of the toaster's manufacturer. For instance, Microsoft Toaster.
     *     </code>
     * </pre>
     *
     * @return {@code DisplayString} toasterManufacturer, or {@code null} if it is not present.
     *
     */
    DisplayString getToasterManufacturer();
    
    /**
     * Return toasterManufacturer, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The name of the toaster's manufacturer. For instance, Microsoft Toaster.
     *     </code>
     * </pre>
     *
     * @return {@code DisplayString} toasterManufacturer, guaranteed to be non-null.
     * @throws NoSuchElementException if toasterManufacturer is not present
     *
     */
    default @NonNull DisplayString requireToasterManufacturer() {
        return CodeHelpers.require(getToasterManufacturer(), "toastermanufacturer");
    }
    
    /**
     * Return toasterModelNumber, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The name of the toaster's model. For instance, Radiant Automatic.
     *     </code>
     * </pre>
     *
     * @return {@code DisplayString} toasterModelNumber, or {@code null} if it is not present.
     *
     */
    DisplayString getToasterModelNumber();
    
    /**
     * Return toasterModelNumber, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The name of the toaster's model. For instance, Radiant Automatic.
     *     </code>
     * </pre>
     *
     * @return {@code DisplayString} toasterModelNumber, guaranteed to be non-null.
     * @throws NoSuchElementException if toasterModelNumber is not present
     *
     */
    default @NonNull DisplayString requireToasterModelNumber() {
        return CodeHelpers.require(getToasterModelNumber(), "toastermodelnumber");
    }
    
    /**
     * Return toasterStatus, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         This variable indicates the current state of the toaster.
     *     </code>
     * </pre>
     *
     * @return {@code ToasterStatus} toasterStatus, or {@code null} if it is not present.
     *
     */
    ToasterStatus getToasterStatus();
    
    /**
     * Return toasterStatus, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         This variable indicates the current state of the toaster.
     *     </code>
     * </pre>
     *
     * @return {@code ToasterStatus} toasterStatus, guaranteed to be non-null.
     * @throws NoSuchElementException if toasterStatus is not present
     *
     */
    default @NonNull ToasterStatus requireToasterStatus() {
        return CodeHelpers.require(getToasterStatus(), "toasterstatus");
    }
    
    /**
     * Return darknessFactor, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The darkness factor. Basically, the number of ms to multiple the doneness value
     *         by.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} darknessFactor, or {@code null} if it is not present.
     *
     */
    Uint32 getDarknessFactor();
    
    /**
     * Return darknessFactor, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The darkness factor. Basically, the number of ms to multiple the doneness value
     *         by.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} darknessFactor, guaranteed to be non-null.
     * @throws NoSuchElementException if darknessFactor is not present
     *
     */
    default @NonNull Uint32 requireDarknessFactor() {
        return CodeHelpers.require(getDarknessFactor(), "darknessfactor");
    }

}

