package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link MakeToastInput} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     MakeToastInput createMakeToastInput(int fooXyzzy, int barBaz) {
 *         return new MakeToastInputBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of MakeToastInput, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see MakeToastInput
 *
 */
@Generated("mdsal-binding-generator")
public class MakeToastInputBuilder {

    private Uint32 _toasterDoneness;
    private Class<? extends ToastType> _toasterToastType;


    Map<Class<? extends Augmentation<MakeToastInput>>, Augmentation<MakeToastInput>> augmentation = Collections.emptyMap();

    public MakeToastInputBuilder() {
    }
    
    

    public MakeToastInputBuilder(MakeToastInput base) {
        Map<Class<? extends Augmentation<MakeToastInput>>, Augmentation<MakeToastInput>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._toasterDoneness = base.getToasterDoneness();
        this._toasterToastType = base.getToasterToastType();
    }


    public Uint32 getToasterDoneness() {
        return _toasterDoneness;
    }
    
    public Class<? extends ToastType> getToasterToastType() {
        return _toasterToastType;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<MakeToastInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    private static void checkToasterDonenessRange(final long value) {
        if (value >= 1L && value <= 10L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[1..10]]", value);
    }
    
    public MakeToastInputBuilder setToasterDoneness(final Uint32 value) {
        if (value != null) {
            checkToasterDonenessRange(value.longValue());
            
        }
        this._toasterDoneness = value;
        return this;
    }
    
    public MakeToastInputBuilder setToasterToastType(final Class<? extends ToastType> value) {
        this._toasterToastType = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public MakeToastInputBuilder addAugmentation(Augmentation<MakeToastInput> augmentation) {
        Class<? extends Augmentation<MakeToastInput>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public MakeToastInputBuilder removeAugmentation(Class<? extends Augmentation<MakeToastInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link MakeToastInput} instance.
     *
     * @return A new {@link MakeToastInput} instance.
     */
    public MakeToastInput build() {
        return new MakeToastInputImpl(this);
    }

    private static final class MakeToastInputImpl
        extends AbstractAugmentable<MakeToastInput>
        implements MakeToastInput {
    
        private final Uint32 _toasterDoneness;
        private final Class<? extends ToastType> _toasterToastType;
    
        MakeToastInputImpl(MakeToastInputBuilder base) {
            super(base.augmentation);
            this._toasterDoneness = base.getToasterDoneness();
            this._toasterToastType = base.getToasterToastType();
        }
    
        @Override
        public Uint32 getToasterDoneness() {
            return _toasterDoneness;
        }
        
        @Override
        public Class<? extends ToastType> getToasterToastType() {
            return _toasterToastType;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = MakeToastInput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return MakeToastInput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return MakeToastInput.bindingToString(this);
        }
    }
}
