package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>toaster</b>
 * <pre>
 * typedef DisplayString {
 *   type string {
 *     length "0 .. 255";
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public class DisplayString
 implements ScalarTypeObject<String>, Serializable {
    @java.io.Serial
    private static final long serialVersionUID = -5323910593144881832L;
    private final String _value;

    private static void check_valueLength(final String value) {
        final int length = value.codePointCount(0, value.length());
        if (length <= 255) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[0..255]]", value);
    }

    @ConstructorParameters("value")
    public DisplayString(String _value) {
        if (_value != null) {
            check_valueLength(_value);
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public DisplayString(DisplayString source) {
        this._value = source._value;
    }

    public static DisplayString getDefaultInstance(final String defaultValue) {
        return new DisplayString(defaultValue);
    }

    @Override
    public String getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DisplayString)) {
            return false;
        }
        final DisplayString other = (DisplayString) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(DisplayString.class);
        CodeHelpers.appendValue(helper, "value", _value);
        return helper.toString();
    }
}

