package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>toaster</b>
 * <pre>
 * input input {
 *   leaf toasterDoneness {
 *     type uint32 {
 *       range "1 .. 10";
 *     }
 *     default 5;
 *   }
 *   leaf toasterToastType {
 *     type identityref {
 *       base toast-type;
 *     }
 *     default wheat-bread;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface MakeToastInput
    extends
    RpcInput,
    Augmentable<MakeToastInput>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastInput.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.@NonNull MakeToastInput obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getToasterDoneness());
        result = prime * result + Objects.hashCode(obj.getToasterToastType());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.@NonNull MakeToastInput thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastInput other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastInput.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getToasterDoneness(), other.getToasterDoneness())) {
            return false;
        }
        if (!Objects.equals(thisObj.getToasterToastType(), other.getToasterToastType())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.@NonNull MakeToastInput obj) {
        final var helper = MoreObjects.toStringHelper("MakeToastInput");
        CodeHelpers.appendValue(helper, "toasterDoneness", obj.getToasterDoneness());
        CodeHelpers.appendValue(helper, "toasterToastType", obj.getToasterToastType());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return toasterDoneness, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         This variable controls how well-done is the ensuing toast. It should be on a
     *         scale of 1 to 10. Toast made at 10 generally is considered unfit for human
     *         consumption; toast made at 1 is warmed lightly.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} toasterDoneness, or {@code null} if it is not present.
     *
     */
    Uint32 getToasterDoneness();
    
    /**
     * Return toasterDoneness, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         This variable controls how well-done is the ensuing toast. It should be on a
     *         scale of 1 to 10. Toast made at 10 generally is considered unfit for human
     *         consumption; toast made at 1 is warmed lightly.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} toasterDoneness, guaranteed to be non-null.
     * @throws NoSuchElementException if toasterDoneness is not present
     *
     */
    default @NonNull Uint32 requireToasterDoneness() {
        return CodeHelpers.require(getToasterDoneness(), "toasterdoneness");
    }
    
    /**
     * Return toasterToastType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         This variable informs the toaster of the type of material that is being toasted.
     *         The toaster uses this information, combined with toasterDoneness, to compute for
     *         how long the material must be toasted to achieve the required doneness.
     *     </code>
     * </pre>
     *
     * @return {@code ToastType} toasterToastType, or {@code null} if it is not present.
     *
     */
    ToastType getToasterToastType();
    
    /**
     * Return toasterToastType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         This variable informs the toaster of the type of material that is being toasted.
     *         The toaster uses this information, combined with toasterDoneness, to compute for
     *         how long the material must be toasted to achieve the required doneness.
     *     </code>
     * </pre>
     *
     * @return {@code ToastType} toasterToastType, guaranteed to be non-null.
     * @throws NoSuchElementException if toasterToastType is not present
     *
     */
    default @NonNull ToastType requireToasterToastType() {
        return CodeHelpers.require(getToasterToastType(), "toastertoasttype");
    }

}

