package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link Toaster} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Toaster createToaster(int fooXyzzy, int barBaz) {
 *         return new ToasterBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Toaster, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Toaster
 *
 */
@Generated("mdsal-binding-generator")
public class ToasterBuilder {

    private Uint32 _darknessFactor;
    private DisplayString _toasterManufacturer;
    private DisplayString _toasterModelNumber;
    private Toaster.ToasterStatus _toasterStatus;


    Map<Class<? extends Augmentation<Toaster>>, Augmentation<Toaster>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ToasterBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link Toaster}.
     *
     * @param base Toaster from which the builder should be initialized
     */
    public ToasterBuilder(Toaster base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._darknessFactor = base.getDarknessFactor();
        this._toasterManufacturer = base.getToasterManufacturer();
        this._toasterModelNumber = base.getToasterModelNumber();
        this._toasterStatus = base.getToasterStatus();
    }


    /**
     * Return current value associated with the property corresponding to {@link Toaster#getDarknessFactor()}.
     *
     * @return current value
     */
    public Uint32 getDarknessFactor() {
        return _darknessFactor;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Toaster#getToasterManufacturer()}.
     *
     * @return current value
     */
    public DisplayString getToasterManufacturer() {
        return _toasterManufacturer;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Toaster#getToasterModelNumber()}.
     *
     * @return current value
     */
    public DisplayString getToasterModelNumber() {
        return _toasterModelNumber;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Toaster#getToasterStatus()}.
     *
     * @return current value
     */
    public Toaster.ToasterStatus getToasterStatus() {
        return _toasterStatus;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Toaster>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Toaster#getDarknessFactor()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ToasterBuilder setDarknessFactor(final Uint32 value) {
        this._darknessFactor = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Toaster#getToasterManufacturer()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ToasterBuilder setToasterManufacturer(final DisplayString value) {
        this._toasterManufacturer = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Toaster#getToasterModelNumber()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ToasterBuilder setToasterModelNumber(final DisplayString value) {
        this._toasterModelNumber = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Toaster#getToasterStatus()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ToasterBuilder setToasterStatus(final Toaster.ToasterStatus value) {
        this._toasterStatus = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ToasterBuilder addAugmentation(Augmentation<Toaster> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ToasterBuilder removeAugmentation(Class<? extends Augmentation<Toaster>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Toaster} instance.
     *
     * @return A new {@link Toaster} instance.
     */
    public @NonNull Toaster build() {
        return new ToasterImpl(this);
    }

    private static final class ToasterImpl
        extends AbstractAugmentable<Toaster>
        implements Toaster {
    
        private final Uint32 _darknessFactor;
        private final DisplayString _toasterManufacturer;
        private final DisplayString _toasterModelNumber;
        private final Toaster.ToasterStatus _toasterStatus;
    
        ToasterImpl(ToasterBuilder base) {
            super(base.augmentation);
            this._darknessFactor = base.getDarknessFactor();
            this._toasterManufacturer = base.getToasterManufacturer();
            this._toasterModelNumber = base.getToasterModelNumber();
            this._toasterStatus = base.getToasterStatus();
        }
    
        @Override
        public Uint32 getDarknessFactor() {
            return _darknessFactor;
        }
        
        @Override
        public DisplayString getToasterManufacturer() {
            return _toasterManufacturer;
        }
        
        @Override
        public DisplayString getToasterModelNumber() {
            return _toasterModelNumber;
        }
        
        @Override
        public Toaster.ToasterStatus getToasterStatus() {
            return _toasterStatus;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Toaster.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Toaster.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Toaster.bindingToString(this);
        }
    }
}
