/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.DisplayString;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.Toaster;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint32;

public class ToasterBuilder {
    private Uint32 _darknessFactor;
    private DisplayString _toasterManufacturer;
    private DisplayString _toasterModelNumber;
    private Toaster.ToasterStatus _toasterStatus;
    Map<Class<? extends Augmentation<Toaster>>, Augmentation<Toaster>> augmentation = Map.of();

    public ToasterBuilder() {
    }

    public ToasterBuilder(Toaster base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Toaster>>, Augmentation<Toaster>>(aug);
        }
        this._darknessFactor = base.getDarknessFactor();
        this._toasterManufacturer = base.getToasterManufacturer();
        this._toasterModelNumber = base.getToasterModelNumber();
        this._toasterStatus = base.getToasterStatus();
    }

    public Uint32 getDarknessFactor() {
        return this._darknessFactor;
    }

    public DisplayString getToasterManufacturer() {
        return this._toasterManufacturer;
    }

    public DisplayString getToasterModelNumber() {
        return this._toasterModelNumber;
    }

    public Toaster.ToasterStatus getToasterStatus() {
        return this._toasterStatus;
    }

    public <E$$ extends Augmentation<Toaster>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ToasterBuilder setDarknessFactor(Uint32 value) {
        this._darknessFactor = value;
        return this;
    }

    public ToasterBuilder setToasterManufacturer(DisplayString value) {
        this._toasterManufacturer = value;
        return this;
    }

    public ToasterBuilder setToasterModelNumber(DisplayString value) {
        this._toasterModelNumber = value;
        return this;
    }

    public ToasterBuilder setToasterStatus(Toaster.ToasterStatus value) {
        this._toasterStatus = value;
        return this;
    }

    public ToasterBuilder addAugmentation(Augmentation<Toaster> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Toaster>>, Augmentation<Toaster>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ToasterBuilder removeAugmentation(Class<? extends Augmentation<Toaster>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Toaster build() {
        return new ToasterImpl(this);
    }

    private static final class ToasterImpl
    extends AbstractAugmentable<Toaster>
    implements Toaster {
        private final Uint32 _darknessFactor;
        private final DisplayString _toasterManufacturer;
        private final DisplayString _toasterModelNumber;
        private final Toaster.ToasterStatus _toasterStatus;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ToasterImpl(ToasterBuilder base) {
            super(base.augmentation);
            this._darknessFactor = base.getDarknessFactor();
            this._toasterManufacturer = base.getToasterManufacturer();
            this._toasterModelNumber = base.getToasterModelNumber();
            this._toasterStatus = base.getToasterStatus();
        }

        @Override
        public Uint32 getDarknessFactor() {
            return this._darknessFactor;
        }

        @Override
        public DisplayString getToasterManufacturer() {
            return this._toasterManufacturer;
        }

        @Override
        public DisplayString getToasterModelNumber() {
            return this._toasterModelNumber;
        }

        @Override
        public Toaster.ToasterStatus getToasterStatus() {
            return this._toasterStatus;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Toaster.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Toaster.bindingEquals(this, obj);
        }

        public String toString() {
            return Toaster.bindingToString(this);
        }
    }
}

