/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.DisplayString;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterData;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

public interface Toaster
extends ChildOf<ToasterData>,
Augmentable<Toaster> {
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("toaster");

    default public Class<Toaster> implementedInterface() {
        return Toaster.class;
    }

    public static int bindingHashCode(@NonNull Toaster obj) {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(obj.getDarknessFactor());
        result = 31 * result + Objects.hashCode(obj.getToasterManufacturer());
        result = 31 * result + Objects.hashCode(obj.getToasterModelNumber());
        result = 31 * result + Objects.hashCode((Object)obj.getToasterStatus());
        for (Augmentation augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }

    public static boolean bindingEquals(@NonNull Toaster thisObj, Object obj) {
        if (thisObj == obj) {
            return true;
        }
        Toaster other = (Toaster)CodeHelpers.checkCast(Toaster.class, (Object)obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getDarknessFactor(), other.getDarknessFactor())) {
            return false;
        }
        if (!Objects.equals(thisObj.getToasterManufacturer(), other.getToasterManufacturer())) {
            return false;
        }
        if (!Objects.equals(thisObj.getToasterModelNumber(), other.getToasterModelNumber())) {
            return false;
        }
        if (!Objects.equals((Object)thisObj.getToasterStatus(), (Object)other.getToasterStatus())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }

    public static String bindingToString(@NonNull Toaster obj) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Toaster");
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"darknessFactor", (Object)obj.getDarknessFactor());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"toasterManufacturer", (Object)obj.getToasterManufacturer());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"toasterModelNumber", (Object)obj.getToasterModelNumber());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"toasterStatus", (Object)((Object)obj.getToasterStatus()));
        CodeHelpers.appendAugmentations((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Augmentable)obj);
        return helper.toString();
    }

    public DisplayString getToasterManufacturer();

    default public @NonNull DisplayString requireToasterManufacturer() {
        return (DisplayString)CodeHelpers.require((Object)this.getToasterManufacturer(), (String)"toastermanufacturer");
    }

    public DisplayString getToasterModelNumber();

    default public @NonNull DisplayString requireToasterModelNumber() {
        return (DisplayString)CodeHelpers.require((Object)this.getToasterModelNumber(), (String)"toastermodelnumber");
    }

    public ToasterStatus getToasterStatus();

    default public @NonNull ToasterStatus requireToasterStatus() {
        return (ToasterStatus)((Object)CodeHelpers.require((Object)((Object)this.getToasterStatus()), (String)"toasterstatus"));
    }

    public Uint32 getDarknessFactor();

    default public @NonNull Uint32 requireDarknessFactor() {
        return (Uint32)CodeHelpers.require((Object)this.getDarknessFactor(), (String)"darknessfactor");
    }

    public static enum ToasterStatus implements EnumTypeObject
    {
        Up(1, "up"),
        Down(2, "down");

        private final @NonNull String name;
        private final int value;

        private ToasterStatus(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static @Nullable ToasterStatus forName(String name) {
            return switch (name) {
                case "up" -> Up;
                case "down" -> Down;
                default -> null;
            };
        }

        public static @Nullable ToasterStatus forValue(int intValue) {
            return switch (intValue) {
                case 1 -> Up;
                case 2 -> Down;
                default -> null;
            };
        }

        public static @NonNull ToasterStatus ofName(String name) {
            return (ToasterStatus)CodeHelpers.checkEnum((EnumTypeObject)ToasterStatus.forName(name), (String)name);
        }

        public static @NonNull ToasterStatus ofValue(int intValue) {
            return (ToasterStatus)CodeHelpers.checkEnum((EnumTypeObject)ToasterStatus.forValue(intValue), (int)intValue);
        }
    }
}

