package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.shutdown.impl.rev131218;
import java.util.concurrent.Future;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;


/**
 * Interface for implementing the following YANG RPCs defined in module &lt;b&gt;shutdown-impl&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/shutdown-impl.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * rpc shutdown {
 *     input {
 *         leaf context-instance {
 *             type instance-identifier;
 *         }
 *         leaf input-secret {
 *             type string;
 *         }
 *         leaf max-wait-time {
 *             type uint32;
 *         }
 *         leaf reason {
 *             type string;
 *         }
 *     }
 *     
 *     status CURRENT;
 * }
 * &lt;/pre&gt;
 *
 */
public interface ShutdownImplService
    extends
    RpcService
{




    Future<RpcResult<java.lang.Void>> shutdown(ShutdownInput input);

}

