/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.shutdown.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.DependencyResolverFactory;
import org.opendaylight.controller.config.api.DynamicMBeanWithInstance;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.controller.config.yang.shutdown.ShutdownServiceServiceInterface;
import org.opendaylight.controller.config.yang.shutdown.impl.ShutdownModule;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.osgi.framework.BundleContext;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:controller:shutdown:impl", name="shutdown-impl", revision="2013-12-18")
public abstract class AbstractShutdownModuleFactory
implements ModuleFactory {
    public static final String NAME = "shutdown";
    private static final Set<Class<? extends AbstractServiceInterface>> serviceIfcs;

    public final String getImplementationName() {
        return NAME;
    }

    public final boolean isModuleImplementingServiceInterface(Class<? extends AbstractServiceInterface> serviceInterface) {
        for (Class<? extends AbstractServiceInterface> ifc : serviceIfcs) {
            if (!serviceInterface.isAssignableFrom(ifc)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<? extends AbstractServiceInterface>> getImplementedServiceIntefaces() {
        return serviceIfcs;
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return this.instantiateModule(instanceName, dependencyResolver, bundleContext);
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, DynamicMBeanWithInstance old, BundleContext bundleContext) throws Exception {
        ShutdownModule oldModule;
        try {
            oldModule = (ShutdownModule)old.getModule();
        }
        catch (Exception e) {
            return this.handleChangedClass(dependencyResolver, old, bundleContext);
        }
        ShutdownModule module = this.instantiateModule(instanceName, dependencyResolver, oldModule, old.getInstance(), bundleContext);
        module.setSecret(oldModule.getSecret());
        return module;
    }

    public ShutdownModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, ShutdownModule oldModule, AutoCloseable oldInstance, BundleContext bundleContext) {
        return new ShutdownModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver, oldModule, oldInstance);
    }

    public ShutdownModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return new ShutdownModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver);
    }

    public ShutdownModule handleChangedClass(DependencyResolver dependencyResolver, DynamicMBeanWithInstance old, BundleContext bundleContext) throws Exception {
        String instanceName = ((ModuleIdentifier)old.getModule().getIdentifier()).getInstanceName();
        ShutdownModule newModule = new ShutdownModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver);
        Module oldModule = old.getModule();
        Class<?> oldModuleClass = oldModule.getClass();
        newModule.setSecret((String)oldModuleClass.getMethod("getSecret", new Class[0]).invoke((Object)oldModule, new Object[0]));
        return newModule;
    }

    @Deprecated
    public ShutdownModule handleChangedClass(DynamicMBeanWithInstance old) throws Exception {
        throw new UnsupportedOperationException("Class reloading is not supported");
    }

    public Set<ShutdownModule> getDefaultModules(DependencyResolverFactory dependencyResolverFactory, BundleContext bundleContext) {
        return new HashSet<ShutdownModule>();
    }

    static {
        HashSet<Class<ShutdownServiceServiceInterface>> serviceIfcs2 = new HashSet<Class<ShutdownServiceServiceInterface>>();
        serviceIfcs2.add(ShutdownServiceServiceInterface.class);
        serviceIfcs = Collections.unmodifiableSet(serviceIfcs2);
    }
}

