/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.shutdown.impl;

import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.JmxAttributeValidationException;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.shutdown.impl.AbstractShutdownModule;
import org.opendaylight.controller.config.yang.shutdown.impl.ShutdownServiceImpl;
import org.osgi.framework.Bundle;

public final class ShutdownModule
extends AbstractShutdownModule {
    private final Bundle systemBundle;

    public ShutdownModule(ModuleIdentifier identifier, Bundle systemBundle) {
        super(identifier, null);
        ShutdownModule.singletonCheck(identifier);
        this.systemBundle = systemBundle;
    }

    public ShutdownModule(ModuleIdentifier identifier, ShutdownModule oldModule, AutoCloseable oldInstance, Bundle systemBundle) {
        super(identifier, null, oldModule, oldInstance);
        ShutdownModule.singletonCheck(identifier);
        this.systemBundle = systemBundle;
    }

    private static void singletonCheck(ModuleIdentifier identifier) {
        if (!"shutdown".equals(identifier.getInstanceName())) {
            throw new IllegalArgumentException("Singleton enforcement failed. Expected instance name shutdown");
        }
    }

    @Deprecated
    public ShutdownModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, ShutdownModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ShutdownModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
        throw new UnsupportedOperationException();
    }

    @Override
    protected void customValidation() {
        JmxAttributeValidationException.checkNotNull((Object)super.getSecret(), (JmxAttribute)secretJmxAttribute);
    }

    public AutoCloseable createInstance() {
        return new ShutdownServiceImpl(this.getSecret(), this.systemBundle, this.getRootRuntimeBeanRegistratorWrapper());
    }
}

