/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.threadpool.util;

import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class NamingThreadPoolFactory
implements ThreadFactory,
Closeable {
    private final ThreadGroup group;
    private final String namePrefix;
    private final AtomicLong threadName = new AtomicLong();

    public NamingThreadPoolFactory(String namePrefix) {
        this.namePrefix = Objects.requireNonNull(namePrefix);
        this.group = new ThreadGroup(namePrefix);
    }

    @Override
    public Thread newThread(Runnable r) {
        return new Thread(this.group, r, String.format("%s-%d", this.group.getName(), this.threadName.incrementAndGet()));
    }

    @Override
    public void close() {
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }
}

