/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.threadpool.impl;

import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.yang.threadpool.EventBusServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.impl.EventBusModuleMXBean;
import org.opendaylight.controller.config.yang.threadpool.impl.EventBusRuntimeRegistrator;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(revision="2013-04-05", name="threadpool-impl", namespace="urn:opendaylight:params:xml:ns:yang:controller:threadpool:impl")
public abstract class AbstractEventBusModule
implements Module,
EventBusModuleMXBean,
EventBusServiceInterface,
RuntimeBeanRegistratorAwareModule {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEventBusModule.class);
    private final AbstractEventBusModule oldModule;
    private final AutoCloseable oldInstance;
    private AutoCloseable instance;
    protected final DependencyResolver dependencyResolver;
    private final ModuleIdentifier identifier;
    private EventBusRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public AbstractEventBusModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = null;
        this.oldModule = null;
    }

    public AbstractEventBusModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractEventBusModule oldModule, AutoCloseable oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldModule = oldModule;
        this.oldInstance = oldInstance;
    }

    public EventBusRuntimeRegistrator getRootRuntimeBeanRegistratorWrapper() {
        return this.rootRuntimeBeanRegistratorWrapper;
    }

    public void setRuntimeBeanRegistrator(RootRuntimeBeanRegistrator rootRuntimeRegistrator) {
        this.rootRuntimeBeanRegistratorWrapper = new EventBusRuntimeRegistrator(rootRuntimeRegistrator);
    }

    public void validate() {
        this.customValidation();
    }

    protected void customValidation() {
    }

    public final AutoCloseable getInstance() {
        if (this.instance == null) {
            if (this.oldInstance != null && this.canReuseInstance(this.oldModule)) {
                this.instance = this.reuseInstance(this.oldInstance);
            } else {
                if (this.oldInstance != null) {
                    try {
                        this.oldInstance.close();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while closing old instance " + this.oldInstance, (Throwable)e);
                    }
                }
                this.instance = this.createInstance();
                if (this.instance == null) {
                    throw new IllegalStateException("Error in createInstance - null is not allowed as return value");
                }
            }
        }
        return this.instance;
    }

    public abstract AutoCloseable createInstance();

    public boolean canReuseInstance(AbstractEventBusModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractEventBusModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractEventBusModule that = (AbstractEventBusModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

