/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.threadpool.util;

import java.io.Closeable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.opendaylight.controller.config.threadpool.ScheduledThreadPool;

public class ScheduledThreadPoolWrapper
implements ScheduledThreadPool,
Closeable {
    private final ScheduledThreadPoolExecutor executor;
    private final int threadCount;

    public ScheduledThreadPoolWrapper(int threadCount, ThreadFactory factory) {
        this.threadCount = threadCount;
        this.executor = new ScheduledThreadPoolExecutor(threadCount, factory);
        this.executor.prestartAllCoreThreads();
    }

    public ScheduledExecutorService getExecutor() {
        return Executors.unconfigurableScheduledExecutorService(this.executor);
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    public int getMaxThreadCount() {
        return this.threadCount;
    }
}

