/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.threadpool.impl;

import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.threadpool.ThreadPool;
import org.opendaylight.controller.config.yang.threadpool.EventBusServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.ThreadPoolServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.impl.AsyncEventBusModuleMXBean;
import org.opendaylight.controller.config.yang.threadpool.impl.AsyncEventBusRuntimeRegistrator;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(revision="2013-04-05", name="threadpool-impl", namespace="urn:opendaylight:params:xml:ns:yang:controller:threadpool:impl")
public abstract class AbstractAsyncEventBusModule
implements Module,
AsyncEventBusModuleMXBean,
EventBusServiceInterface,
RuntimeBeanRegistratorAwareModule {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAsyncEventBusModule.class);
    public static final JmxAttribute threadpoolJmxAttribute = new JmxAttribute("Threadpool");
    private ObjectName threadpool;
    private final AbstractAsyncEventBusModule oldModule;
    private final AutoCloseable oldInstance;
    private AutoCloseable instance;
    protected final DependencyResolver dependencyResolver;
    private final ModuleIdentifier identifier;
    private AsyncEventBusRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;
    private ThreadPool threadpoolDependency;

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public AbstractAsyncEventBusModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = null;
        this.oldModule = null;
    }

    public AbstractAsyncEventBusModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractAsyncEventBusModule oldModule, AutoCloseable oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldModule = oldModule;
        this.oldInstance = oldInstance;
    }

    public AsyncEventBusRuntimeRegistrator getRootRuntimeBeanRegistratorWrapper() {
        return this.rootRuntimeBeanRegistratorWrapper;
    }

    public void setRuntimeBeanRegistrator(RootRuntimeBeanRegistrator rootRuntimeRegistrator) {
        this.rootRuntimeBeanRegistratorWrapper = new AsyncEventBusRuntimeRegistrator(rootRuntimeRegistrator);
    }

    public void validate() {
        this.dependencyResolver.validateDependency(ThreadPoolServiceInterface.class, this.threadpool, threadpoolJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final ThreadPool getThreadpoolDependency() {
        return this.threadpoolDependency;
    }

    public final AutoCloseable getInstance() {
        if (this.instance == null) {
            this.threadpoolDependency = (ThreadPool)this.dependencyResolver.resolveInstance(ThreadPool.class, this.threadpool, threadpoolJmxAttribute);
            if (this.oldInstance != null && this.canReuseInstance(this.oldModule)) {
                this.instance = this.reuseInstance(this.oldInstance);
            } else {
                if (this.oldInstance != null) {
                    try {
                        this.oldInstance.close();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while closing old instance " + this.oldInstance, (Throwable)e);
                    }
                }
                this.instance = this.createInstance();
                if (this.instance == null) {
                    throw new IllegalStateException("Error in createInstance - null is not allowed as return value");
                }
            }
        }
        return this.instance;
    }

    public abstract AutoCloseable createInstance();

    public boolean canReuseInstance(AbstractAsyncEventBusModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractAsyncEventBusModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        return this.threadpoolDependency == other.threadpoolDependency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractAsyncEventBusModule that = (AbstractAsyncEventBusModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public ObjectName getThreadpool() {
        return this.threadpool;
    }

    @Override
    @RequireInterface(value=ThreadPoolServiceInterface.class)
    public void setThreadpool(ObjectName threadpool) {
        this.threadpool = threadpool;
    }
}

