/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.threadpool.impl;

import java.util.Objects;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.yang.threadpool.ThreadFactoryServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.impl.NamingThreadFactoryModuleMXBean;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(revision="2013-04-05", name="threadpool-impl", namespace="urn:opendaylight:params:xml:ns:yang:controller:threadpool:impl")
public abstract class AbstractNamingThreadFactoryModule
implements Module,
NamingThreadFactoryModuleMXBean,
ThreadFactoryServiceInterface {
    private static final Logger logger = LoggerFactory.getLogger(AbstractNamingThreadFactoryModule.class);
    public static final JmxAttribute namePrefixJmxAttribute = new JmxAttribute("NamePrefix");
    private String namePrefix;
    private final AbstractNamingThreadFactoryModule oldModule;
    private final AutoCloseable oldInstance;
    private AutoCloseable instance;
    protected final DependencyResolver dependencyResolver;
    private final ModuleIdentifier identifier;

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public AbstractNamingThreadFactoryModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = null;
        this.oldModule = null;
    }

    public AbstractNamingThreadFactoryModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractNamingThreadFactoryModule oldModule, AutoCloseable oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldModule = oldModule;
        this.oldInstance = oldInstance;
    }

    public void validate() {
        this.customValidation();
    }

    protected void customValidation() {
    }

    public final AutoCloseable getInstance() {
        if (this.instance == null) {
            if (this.oldInstance != null && this.canReuseInstance(this.oldModule)) {
                this.instance = this.reuseInstance(this.oldInstance);
            } else {
                if (this.oldInstance != null) {
                    try {
                        this.oldInstance.close();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while closing old instance " + this.oldInstance, (Throwable)e);
                    }
                }
                this.instance = this.createInstance();
                if (this.instance == null) {
                    throw new IllegalStateException("Error in createInstance - null is not allowed as return value");
                }
            }
        }
        return this.instance;
    }

    public abstract AutoCloseable createInstance();

    public boolean canReuseInstance(AbstractNamingThreadFactoryModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractNamingThreadFactoryModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        return Objects.deepEquals(this.namePrefix, other.namePrefix);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNamingThreadFactoryModule that = (AbstractNamingThreadFactoryModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public String getNamePrefix() {
        return this.namePrefix;
    }

    @Override
    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }
}

