/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.threadpool.impl.scheduled;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.yang.threadpool.ScheduledThreadPoolServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.ThreadFactoryServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.impl.scheduled.ScheduledThreadPoolModuleMXBean;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(revision="2013-12-01", name="threadpool-impl-scheduled", namespace="urn:opendaylight:params:xml:ns:yang:controller:threadpool:impl:scheduled")
public abstract class AbstractScheduledThreadPoolModule
implements Module,
ScheduledThreadPoolModuleMXBean,
ScheduledThreadPoolServiceInterface {
    private static final Logger logger = LoggerFactory.getLogger(AbstractScheduledThreadPoolModule.class);
    public static final JmxAttribute threadFactoryJmxAttribute = new JmxAttribute("ThreadFactory");
    private ObjectName threadFactory;
    public static final JmxAttribute maxThreadCountJmxAttribute = new JmxAttribute("MaxThreadCount");
    private Integer maxThreadCount;
    private final AbstractScheduledThreadPoolModule oldModule;
    private final AutoCloseable oldInstance;
    private AutoCloseable instance;
    protected final DependencyResolver dependencyResolver;
    private final ModuleIdentifier identifier;
    private ThreadFactory threadFactoryDependency;

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public AbstractScheduledThreadPoolModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = null;
        this.oldModule = null;
    }

    public AbstractScheduledThreadPoolModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractScheduledThreadPoolModule oldModule, AutoCloseable oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldModule = oldModule;
        this.oldInstance = oldInstance;
    }

    public void validate() {
        this.dependencyResolver.validateDependency(ThreadFactoryServiceInterface.class, this.threadFactory, threadFactoryJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final ThreadFactory getThreadFactoryDependency() {
        return this.threadFactoryDependency;
    }

    public final AutoCloseable getInstance() {
        if (this.instance == null) {
            this.threadFactoryDependency = (ThreadFactory)this.dependencyResolver.resolveInstance(ThreadFactory.class, this.threadFactory, threadFactoryJmxAttribute);
            if (this.oldInstance != null && this.canReuseInstance(this.oldModule)) {
                this.instance = this.reuseInstance(this.oldInstance);
            } else {
                if (this.oldInstance != null) {
                    try {
                        this.oldInstance.close();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while closing old instance " + this.oldInstance, (Throwable)e);
                    }
                }
                this.instance = this.createInstance();
                if (this.instance == null) {
                    throw new IllegalStateException("Error in createInstance - null is not allowed as return value");
                }
            }
        }
        return this.instance;
    }

    public abstract AutoCloseable createInstance();

    public boolean canReuseInstance(AbstractScheduledThreadPoolModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractScheduledThreadPoolModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (this.threadFactoryDependency != other.threadFactoryDependency) {
            return false;
        }
        return Objects.deepEquals(this.maxThreadCount, other.maxThreadCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractScheduledThreadPoolModule that = (AbstractScheduledThreadPoolModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public ObjectName getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    @RequireInterface(value=ThreadFactoryServiceInterface.class)
    public void setThreadFactory(ObjectName threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    public Integer getMaxThreadCount() {
        return this.maxThreadCount;
    }

    @Override
    public void setMaxThreadCount(Integer maxThreadCount) {
        this.maxThreadCount = maxThreadCount;
    }
}

