/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.fixed.rev131201.modules.module.configuration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.fixed.rev131201.modules.module.configuration.ThreadpoolFixed;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.fixed.rev131201.modules.module.configuration.threadpool.fixed.ThreadFactory;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ThreadpoolFixedBuilder {
    private Integer _maxThreadCount;
    private static List<Range<BigInteger>> _maxThreadCount_range;
    private ThreadFactory _threadFactory;
    Map<Class<? extends Augmentation<ThreadpoolFixed>>, Augmentation<ThreadpoolFixed>> augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolFixed>>, Augmentation<ThreadpoolFixed>>();

    public ThreadpoolFixedBuilder() {
    }

    public ThreadpoolFixedBuilder(ThreadpoolFixed base) {
        this._maxThreadCount = base.getMaxThreadCount();
        this._threadFactory = base.getThreadFactory();
        if (base instanceof ThreadpoolFixedImpl) {
            ThreadpoolFixedImpl _impl = (ThreadpoolFixedImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolFixed>>, Augmentation<ThreadpoolFixed>>(_impl.augmentation);
        }
    }

    public Integer getMaxThreadCount() {
        return this._maxThreadCount;
    }

    public ThreadFactory getThreadFactory() {
        return this._threadFactory;
    }

    public <E extends Augmentation<ThreadpoolFixed>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ThreadpoolFixedBuilder setMaxThreadCount(Integer value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.intValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : ThreadpoolFixedBuilder._maxThreadCount_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _maxThreadCount_range));
            }
        }
        this._maxThreadCount = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _maxThreadCount_range() {
        if (_maxThreadCount_range != null) return _maxThreadCount_range;
        Class<ThreadpoolFixedBuilder> clazz = ThreadpoolFixedBuilder.class;
        synchronized (ThreadpoolFixedBuilder.class) {
            if (_maxThreadCount_range != null) return _maxThreadCount_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
            _maxThreadCount_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _maxThreadCount_range;
        }
    }

    public ThreadpoolFixedBuilder setThreadFactory(ThreadFactory value) {
        this._threadFactory = value;
        return this;
    }

    public ThreadpoolFixedBuilder addAugmentation(Class<? extends Augmentation<ThreadpoolFixed>> augmentationType, Augmentation<ThreadpoolFixed> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ThreadpoolFixed build() {
        return new ThreadpoolFixedImpl(this);
    }

    private static final class ThreadpoolFixedImpl
    implements ThreadpoolFixed {
        private final Integer _maxThreadCount;
        private final ThreadFactory _threadFactory;
        private Map<Class<? extends Augmentation<ThreadpoolFixed>>, Augmentation<ThreadpoolFixed>> augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolFixed>>, Augmentation<ThreadpoolFixed>>();

        public Class<ThreadpoolFixed> getImplementedInterface() {
            return ThreadpoolFixed.class;
        }

        private ThreadpoolFixedImpl(ThreadpoolFixedBuilder base) {
            this._maxThreadCount = base.getMaxThreadCount();
            this._threadFactory = base.getThreadFactory();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ThreadpoolFixed>>, Augmentation<ThreadpoolFixed>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolFixed>>, Augmentation<ThreadpoolFixed>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getMaxThreadCount() {
            return this._maxThreadCount;
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this._threadFactory;
        }

        public <E extends Augmentation<ThreadpoolFixed>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._maxThreadCount == null ? 0 : this._maxThreadCount.hashCode());
            result = 31 * result + (this._threadFactory == null ? 0 : this._threadFactory.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ThreadpoolFixed.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ThreadpoolFixed other = (ThreadpoolFixed)obj;
            if (this._maxThreadCount == null ? other.getMaxThreadCount() != null : !this._maxThreadCount.equals(other.getMaxThreadCount())) {
                return false;
            }
            if (this._threadFactory == null ? other.getThreadFactory() != null : !this._threadFactory.equals(other.getThreadFactory())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ThreadpoolFixedImpl otherImpl = (ThreadpoolFixedImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ThreadpoolFixed>>, Augmentation<ThreadpoolFixed>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ThreadpoolFixed [");
            boolean first = true;
            if (this._maxThreadCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxThreadCount=");
                builder.append(this._maxThreadCount);
            }
            if (this._threadFactory != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_threadFactory=");
                builder.append(this._threadFactory);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

